/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css.swing;

import aurelienribon.ui.css.BaseFunction;
import aurelienribon.ui.css.StyleFunction;
import java.awt.Color;
import java.awt.Font;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class SwingFunctions {
    public static final StyleFunction URL = new BaseFunction("url"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{String.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"absoluteUrl"}};
        }

        @Override
        public Class getReturn() {
            return URL.class;
        }

        @Override
        public Object process(List<Object> list) {
            String string = (String)list.get(0);
            return this.getClass().getResource(string);
        }
    };
    public static final StyleFunction ICON = new BaseFunction("icon"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{URL.class}, {String.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"url"}, {"filepath"}};
        }

        @Override
        public Class getReturn() {
            return ImageIcon.class;
        }

        @Override
        public Object process(List<Object> list) {
            if (list.get(0) instanceof URL) {
                return new ImageIcon((URL)list.get(0));
            }
            if (list.get(0) instanceof String) {
                return new ImageIcon((String)list.get(0));
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction FONT = new BaseFunction("font"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{String.class, String.class, Integer.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"name", "style", "size"}};
        }

        @Override
        public String[] getKeywords(int n, int n2) {
            if (n2 == 1) {
                return new String[]{"plain", "italic", "bold"};
            }
            return null;
        }

        @Override
        public Class getReturn() {
            return Font.class;
        }

        @Override
        public Object process(List<Object> list) {
            String string = (String)list.get(0);
            String string2 = (String)list.get(1);
            int n = (Integer)list.get(2);
            int n2 = -1;
            if (string2.equals("plain")) {
                n2 = 0;
            } else if (string2.equals("italic")) {
                n2 = 2;
            } else if (string2.equals("bold")) {
                n2 = 1;
            } else assert (false);
            return new Font(string, n2, n);
        }
    };
    public static final StyleFunction RGB = new BaseFunction("rgb"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Integer.class, Integer.class, Integer.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"r", "g", "b"}};
        }

        @Override
        public Class getReturn() {
            return Color.class;
        }

        @Override
        public Object process(List<Object> list) {
            int n = (Integer)list.get(0);
            int n2 = (Integer)list.get(1);
            int n3 = (Integer)list.get(2);
            return new Color(n, n2, n3);
        }
    };
    public static final StyleFunction RGBA = new BaseFunction("rgba"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Integer.class, Integer.class, Integer.class, Float.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"r", "g", "b", "a"}};
        }

        @Override
        public Class getReturn() {
            return Color.class;
        }

        @Override
        public Object process(List<Object> list) {
            int n = (Integer)list.get(0);
            int n2 = (Integer)list.get(1);
            int n3 = (Integer)list.get(2);
            int n4 = (int)(((Float)list.get(3)).floatValue() * 255.0f);
            return new Color(n, n2, n3, n4);
        }
    };
    public static final StyleFunction LINEARGRADIENT = new BaseFunction("lineargradient"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Number.class, Number.class, Number.class, Number.class, Number.class, Color.class, Number.class, Color.class}, {Number.class, Number.class, Number.class, Number.class, Number.class, Color.class, Number.class, Color.class, Number.class, Color.class}, {Number.class, Number.class, Number.class, Number.class, Number.class, Color.class, Number.class, Color.class, Number.class, Color.class, Number.class, Color.class}, {Number.class, Number.class, Number.class, Number.class, Number.class, Color.class, Number.class, Color.class, Number.class, Color.class, Number.class, Color.class, Number.class, Color.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"x1", "y1", "x2", "y2", "fraction1", "color1", "fraction2", "color2"}, {"x1", "y1", "x2", "y2", "fraction1", "color1", "fraction2", "color2", "fraction3", "color3"}, {"x1", "y1", "x2", "y2", "fraction1", "color1", "fraction2", "color2", "fraction3", "color3", "fraction4", "color4"}, {"x1", "y1", "x2", "y2", "fraction1", "color1", "fraction2", "color2", "fraction3", "color3", "fraction4", "color4", "fraction5", "color5"}};
        }

        @Override
        public Class getReturn() {
            return LinearGradientPaint.class;
        }

        @Override
        public Object process(List<Object> list) {
            float f = ((Number)list.get(0)).floatValue();
            float f2 = ((Number)list.get(1)).floatValue();
            float f3 = ((Number)list.get(2)).floatValue();
            float f4 = ((Number)list.get(3)).floatValue();
            int n = (list.size() - 4) / 2;
            float[] fArray = new float[n];
            Color[] colorArray = new Color[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = ((Number)list.get(4 + i * 2)).floatValue();
                colorArray[i] = (Color)list.get(5 + i * 2);
            }
            return new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray);
        }
    };
    public static final StyleFunction EMPTYBORDER = new BaseFunction("emptyborder"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Integer.class, Integer.class, Integer.class, Integer.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"top", "left", "bottom", "right"}};
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            int n = (Integer)list.get(0);
            int n2 = (Integer)list.get(1);
            int n3 = (Integer)list.get(2);
            int n4 = (Integer)list.get(4);
            return BorderFactory.createEmptyBorder(n, n2, n3, n4);
        }
    };
    public static final StyleFunction LINEBORDER = new BaseFunction("lineborder"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Color.class}, {Color.class, Integer.class}, {Color.class, Integer.class, Boolean.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"color"}, {"color", "thickness"}, {"color", "thickness", "rounded"}};
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            if (list.size() == 1) {
                Color color = (Color)list.get(0);
                return BorderFactory.createLineBorder(color);
            }
            if (list.size() == 2) {
                Color color = (Color)list.get(0);
                int n = (Integer)list.get(1);
                return BorderFactory.createLineBorder(color, n);
            }
            if (list.size() == 2) {
                Color color = (Color)list.get(0);
                int n = (Integer)list.get(1);
                boolean bl = (Boolean)list.get(2);
                return BorderFactory.createLineBorder(color, n, bl);
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction MATTEBORDER = new BaseFunction("matteborder"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Integer.class, Integer.class, Integer.class, Integer.class, Color.class}, {Integer.class, Integer.class, Integer.class, Integer.class, Icon.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"top", "left", "bottom", "up", "color"}, {"top", "left", "bottom", "up", "tileIcon"}};
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            int n = (Integer)list.get(0);
            int n2 = (Integer)list.get(1);
            int n3 = (Integer)list.get(2);
            int n4 = (Integer)list.get(3);
            if (list.get(4) instanceof Color) {
                Color color = (Color)list.get(4);
                return BorderFactory.createMatteBorder(n, n2, n3, n4, color);
            }
            if (list.get(4) instanceof Icon) {
                Icon icon = (Icon)list.get(4);
                return BorderFactory.createMatteBorder(n, n2, n3, n4, icon);
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction BEVELBORDER = new BaseFunction("bevelborder"){

        @Override
        public String[] getKeywords(int n, int n2) {
            if (n2 == 0) {
                return new String[]{"lowered", "raised"};
            }
            return null;
        }

        @Override
        public Class[][] getParams() {
            return new Class[][]{{String.class}, {String.class, Color.class, Color.class}, {String.class, Color.class, Color.class, Color.class, Color.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"type"}, {"type", "highlight", "shadow"}, {"type", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"}};
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            int n;
            String string = (String)list.get(0);
            int n2 = n = string.equals("lowered") ? 1 : 0;
            if (list.size() == 1) {
                return BorderFactory.createBevelBorder(n);
            }
            if (list.size() == 3) {
                Color color = (Color)list.get(1);
                Color color2 = (Color)list.get(2);
                return BorderFactory.createBevelBorder(n, color, color2);
            }
            if (list.size() == 5) {
                Color color = (Color)list.get(1);
                Color color3 = (Color)list.get(2);
                Color color4 = (Color)list.get(3);
                Color color5 = (Color)list.get(4);
                return BorderFactory.createBevelBorder(n, color, color3, color4, color5);
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction SOFTBEVELBORDER = new BaseFunction("softbevelborder"){

        @Override
        public String[] getKeywords(int n, int n2) {
            if (n2 == 0) {
                return new String[]{"lowered", "raised"};
            }
            return null;
        }

        @Override
        public Class[][] getParams() {
            return new Class[][]{{String.class}, {String.class, Color.class, Color.class}, {String.class, Color.class, Color.class, Color.class, Color.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"type"}, {"type", "highlight", "shadow"}, {"type", "highlightOuter", "highlightInner", "shadowOuter", "shadowInner"}};
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            int n;
            String string = (String)list.get(0);
            int n2 = n = string.equals("lowered") ? 1 : 0;
            if (list.size() == 1) {
                return BorderFactory.createSoftBevelBorder(n);
            }
            if (list.size() == 3) {
                Color color = (Color)list.get(1);
                Color color2 = (Color)list.get(2);
                return BorderFactory.createSoftBevelBorder(n, color, color2);
            }
            if (list.size() == 5) {
                Color color = (Color)list.get(1);
                Color color3 = (Color)list.get(2);
                Color color4 = (Color)list.get(3);
                Color color5 = (Color)list.get(4);
                return BorderFactory.createSoftBevelBorder(n, color, color3, color4, color5);
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction COMPOUNDBORDER = new BaseFunction("compoundborder"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{new Class[0], {Border.class, Border.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{new String[0], {"outsideBorder", "insideBorder"}};
        }

        @Override
        public boolean canBeNull(int n, int n2) {
            return true;
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            if (list.isEmpty()) {
                return BorderFactory.createCompoundBorder();
            }
            if (list.size() == 2) {
                Border border = (Border)list.get(0);
                Border border2 = (Border)list.get(1);
                return BorderFactory.createCompoundBorder(border, border2);
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction DASHEDBORDER = new BaseFunction("dashedborder"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Paint.class}, {Paint.class, Number.class, Number.class}, {Paint.class, Number.class, Number.class, Number.class, Boolean.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"paint"}, {"paint", "length", "spacing"}, {"paint", "thickness", "length", "spacing", "rounded"}};
        }

        @Override
        public boolean canBeNull(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            if (list.size() == 1) {
                Paint paint = (Paint)list.get(0);
                return BorderFactory.createDashedBorder(paint);
            }
            if (list.size() == 2) {
                Paint paint = (Paint)list.get(0);
                float f = ((Float)list.get(1)).floatValue();
                float f2 = ((Float)list.get(2)).floatValue();
                return BorderFactory.createDashedBorder(paint, f, f2);
            }
            if (list.size() == 4) {
                Paint paint = (Paint)list.get(0);
                float f = ((Float)list.get(1)).floatValue();
                float f3 = ((Float)list.get(2)).floatValue();
                float f4 = ((Float)list.get(3)).floatValue();
                boolean bl = (Boolean)list.get(4);
                return BorderFactory.createDashedBorder(paint, f, f3, f4, bl);
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction ETCHEDBORDER = new BaseFunction("etchedborder"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{new Class[0], {Integer.class}, {Color.class, Color.class}, {Integer.class, Color.class, Color.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{new String[0], {"type"}, {"highlight", "shadow"}, {"type", "highlight", "shadow"}};
        }

        @Override
        public boolean canBeNull(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            if (list.isEmpty()) {
                return BorderFactory.createEtchedBorder();
            }
            if (list.size() == 1) {
                int n = (Integer)list.get(0);
                return BorderFactory.createEtchedBorder(n);
            }
            if (list.size() == 2) {
                Color color = (Color)list.get(0);
                Color color2 = (Color)list.get(1);
                return BorderFactory.createEtchedBorder(color, color2);
            }
            if (list.size() == 3) {
                int n = (Integer)list.get(0);
                Color color = (Color)list.get(1);
                Color color3 = (Color)list.get(2);
                return BorderFactory.createEtchedBorder(n, color, color3);
            }
            assert (false);
            return null;
        }
    };
    public static final StyleFunction TITLEDBORDER = new BaseFunction("titledborder"){

        @Override
        public Class[][] getParams() {
            return new Class[][]{{Border.class}, {String.class}, {Border.class, String.class}, {Border.class, String.class, Integer.class, Integer.class}, {Border.class, String.class, Integer.class, Integer.class, Font.class}, {Border.class, String.class, Integer.class, Integer.class, Font.class, Color.class}};
        }

        @Override
        public String[][] getParamsNames() {
            return new String[][]{{"border"}, {"title"}, {"border", "title"}, {"border", "title", "titleJustification", "titlePosition"}, {"border", "title", "titleJustification", "titlePosition", "titleFont"}, {"border", "title", "titleJustification", "titlePosition", "titleFont", "titleColor"}};
        }

        @Override
        public boolean canBeNull(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Class getReturn() {
            return Border.class;
        }

        @Override
        public Object process(List<Object> list) {
            if (list.size() == 1 && list.get(0) instanceof Border) {
                Border border = (Border)list.get(0);
                return BorderFactory.createTitledBorder(border);
            }
            if (list.size() == 1 && list.get(0) instanceof String) {
                String string = (String)list.get(0);
                return BorderFactory.createTitledBorder(string);
            }
            if (list.size() == 2) {
                Border border = (Border)list.get(0);
                String string = (String)list.get(1);
                return BorderFactory.createTitledBorder(border, string);
            }
            if (list.size() == 4) {
                Border border = (Border)list.get(0);
                String string = (String)list.get(1);
                int n = (Integer)list.get(2);
                int n2 = (Integer)list.get(3);
                return BorderFactory.createTitledBorder(border, string, n, n2);
            }
            if (list.size() == 5) {
                Border border = (Border)list.get(0);
                String string = (String)list.get(1);
                int n = (Integer)list.get(2);
                int n3 = (Integer)list.get(3);
                Font font = (Font)list.get(4);
                return BorderFactory.createTitledBorder(border, string, n, n3, font);
            }
            if (list.size() == 6) {
                Border border = (Border)list.get(0);
                String string = (String)list.get(1);
                int n = (Integer)list.get(2);
                int n4 = (Integer)list.get(3);
                Font font = (Font)list.get(4);
                Color color = (Color)list.get(5);
                return BorderFactory.createTitledBorder(border, string, n, n4, font, color);
            }
            assert (false);
            return null;
        }
    };
}

