/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css;

import aurelienribon.ui.css.Style;
import aurelienribon.ui.css.StyleClass;
import aurelienribon.ui.css.StyleRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StyleRuleSet {
    private final List<StyleRule> rules;
    private final Map<StyleRule, List<Object>> rulesParams;

    public StyleRuleSet(List<StyleRule> list, Map<StyleRule, List<Object>> map) {
        this.rules = Collections.unmodifiableList(new ArrayList<StyleRule>(list));
        this.rulesParams = Collections.unmodifiableMap(new HashMap<StyleRule, List<Object>>(map));
    }

    public StyleRuleSet(Style style, Object object, List<String> list) {
        ArrayList<StyleRule> arrayList = new ArrayList<StyleRule>();
        HashMap<StyleRule, List<Object>> hashMap = new HashMap<StyleRule, List<Object>>();
        for (StyleClass styleClass : style.getClasses()) {
            if (!this.isLastSelectorValid(styleClass.getLastSelector(), object) || !this.isStackValid(styleClass.getSelectors(), list)) continue;
            arrayList.addAll(styleClass.getRuleSet().getRules());
            hashMap.putAll(styleClass.getRuleSet().getRulesParams());
        }
        this.rules = Collections.unmodifiableList(arrayList);
        this.rulesParams = Collections.unmodifiableMap(hashMap);
    }

    public StyleRuleSet(StyleRuleSet styleRuleSet, StyleRule[] styleRuleArray) {
        ArrayList<StyleRule> arrayList = new ArrayList<StyleRule>();
        HashMap<StyleRule, List<Object>> hashMap = new HashMap<StyleRule, List<Object>>();
        for (StyleRule styleRule : styleRuleArray) {
            if (!styleRuleSet.getRules().contains(styleRule)) continue;
            arrayList.add(styleRule);
            hashMap.put(styleRule, styleRuleSet.getParams(styleRule));
        }
        this.rules = Collections.unmodifiableList(new ArrayList(arrayList));
        this.rulesParams = Collections.unmodifiableMap(new HashMap(hashMap));
    }

    public List<StyleRule> getRules() {
        return this.rules;
    }

    public Map<StyleRule, List<Object>> getRulesParams() {
        return this.rulesParams;
    }

    public List<Object> getParams(StyleRule styleRule) {
        return this.rulesParams.get(styleRule);
    }

    public boolean contains(StyleRule styleRule) {
        return this.rules.contains(styleRule);
    }

    public Boolean asBoolean(StyleRule styleRule, int n) {
        return (Boolean)this.rulesParams.get(styleRule).get(n);
    }

    public Integer asInteger(StyleRule styleRule, int n) {
        return (Integer)this.rulesParams.get(styleRule).get(n);
    }

    public Float asFloat(StyleRule styleRule, int n) {
        return (Float)this.rulesParams.get(styleRule).get(n);
    }

    public String asString(StyleRule styleRule, int n) {
        return (String)this.rulesParams.get(styleRule).get(n);
    }

    private boolean isLastSelectorValid(String string, Object object) {
        if (string.startsWith(".")) {
            String string2 = Style.getRegisteredTargetClassName(object);
            return string2 != null && string2.equals(string);
        }
        try {
            Class<?> clazz = Class.forName(string.replaceAll("-", "."));
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private boolean isStackValid(List<String> list, List<String> list2) {
        int n;
        int n2;
        if (list.size() == 1) {
            return true;
        }
        for (n2 = 0; n2 < list.size() - 1; ++n2) {
            n = list2.indexOf(list.get(n2));
            if (n != -1) continue;
            return false;
        }
        for (n2 = 1; n2 < list.size() - 1; ++n2) {
            int n3;
            n = list2.indexOf(list.get(n2 - 1));
            if (n < (n3 = list2.lastIndexOf(list.get(n2)))) continue;
            return false;
        }
        return true;
    }
}

