/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.AruiRules;
import aurelienribon.ui.components.TabPanelModel;
import aurelienribon.ui.css.StyleProcessor;
import aurelienribon.ui.css.StyleRuleSet;
import aurelienribon.ui.css.swing.PaintUtils;
import aurelienribon.ui.css.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class TabPanelHeaderSubPanel
extends JComponent {
    public static final StyleProcessor PROCESSOR = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof TabPanelHeaderSubPanel) {
                TabPanelHeaderSubPanel tabPanelHeaderSubPanel = (TabPanelHeaderSubPanel)object;
                if (styleRuleSet.contains(AruiRules.FOREGROUND_UNSELECTED)) {
                    tabPanelHeaderSubPanel.foregroundUnselected = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.FOREGROUND_UNSELECTED), 0);
                }
                if (styleRuleSet.contains(AruiRules.FOREGROUND_SELECTED)) {
                    tabPanelHeaderSubPanel.foregroundSelected = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.FOREGROUND_SELECTED), 0);
                }
                if (styleRuleSet.contains(AruiRules.FOREGROUND_MOUSEOVER)) {
                    tabPanelHeaderSubPanel.foregroundMouseOver = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.FOREGROUND_MOUSEOVER), 0);
                }
                if (styleRuleSet.contains(AruiRules.STROKE)) {
                    tabPanelHeaderSubPanel.stroke = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE), 0);
                }
                if (styleRuleSet.contains(AruiRules.STROKE_UNSELECTED)) {
                    tabPanelHeaderSubPanel.strokeUnselected = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE_UNSELECTED), 0);
                }
                if (styleRuleSet.contains(AruiRules.STROKE_SELECTED)) {
                    tabPanelHeaderSubPanel.strokeSelected = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE_SELECTED), 0);
                }
                if (styleRuleSet.contains(AruiRules.STROKE_MOUSEOVER)) {
                    tabPanelHeaderSubPanel.strokeMouseOver = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE_MOUSEOVER), 0);
                }
                if (styleRuleSet.contains(AruiRules.FILL_UNSELECTED)) {
                    tabPanelHeaderSubPanel.fillUnselected = SwingUtils.asPaint(styleRuleSet.getParams(AruiRules.FILL_UNSELECTED), 0);
                }
                if (styleRuleSet.contains(AruiRules.FILL_SELECTED)) {
                    tabPanelHeaderSubPanel.fillSelected = SwingUtils.asPaint(styleRuleSet.getParams(AruiRules.FILL_SELECTED), 0);
                }
                if (styleRuleSet.contains(AruiRules.FILL_MOUSEOVER)) {
                    tabPanelHeaderSubPanel.fillMouseOver = SwingUtils.asPaint(styleRuleSet.getParams(AruiRules.FILL_MOUSEOVER), 0);
                }
                tabPanelHeaderSubPanel.reload();
            }
        }
    };
    private static final ImageIcon IC_CROSS1_DARK = new ImageIcon(TabPanelHeaderSubPanel.class.getResource("ic_cross1_dark.png"));
    private static final ImageIcon IC_CROSS2_DARK = new ImageIcon(TabPanelHeaderSubPanel.class.getResource("ic_cross2_dark.png"));
    private static final ImageIcon IC_CROSS1_LIGHT = new ImageIcon(TabPanelHeaderSubPanel.class.getResource("ic_cross1_light.png"));
    private static final ImageIcon IC_CROSS2_LIGHT = new ImageIcon(TabPanelHeaderSubPanel.class.getResource("ic_cross2_light.png"));
    private final TabPanelModel.TabModel model;
    private final Callback callback;
    private final JLabel descLabel;
    private final JLabel crossLabel;
    private boolean isMouseOver = false;
    private Color foregroundUnselected = Color.RED;
    private Color foregroundSelected = Color.RED;
    private Color foregroundMouseOver = Color.RED;
    private Color stroke = Color.RED;
    private Color strokeUnselected = Color.RED;
    private Color strokeSelected = Color.RED;
    private Color strokeMouseOver = Color.RED;
    private Paint fillUnselected = Color.RED;
    private Paint fillSelected = Color.RED;
    private Paint fillMouseOver = Color.RED;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TabPanelHeaderSubPanel.this.isMouseOver = true;
            TabPanelHeaderSubPanel.this.reload();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TabPanelHeaderSubPanel.this.isMouseOver = false;
            TabPanelHeaderSubPanel.this.reload();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                TabPanelHeaderSubPanel.this.callback.selectRequested(TabPanelHeaderSubPanel.this.model);
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                TabPanelHeaderSubPanel.this.callback.closeRequested(TabPanelHeaderSubPanel.this.model);
            }
            if (mouseEvent.isPopupTrigger()) {
                new PopupMenu().show(TabPanelHeaderSubPanel.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                new PopupMenu().show(TabPanelHeaderSubPanel.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };
    private final MouseAdapter crossMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (TabPanelHeaderSubPanel.this.crossLabel.getIcon() == IC_CROSS1_DARK) {
                TabPanelHeaderSubPanel.this.crossLabel.setIcon(IC_CROSS2_DARK);
            } else if (TabPanelHeaderSubPanel.this.crossLabel.getIcon() == IC_CROSS1_LIGHT) {
                TabPanelHeaderSubPanel.this.crossLabel.setIcon(IC_CROSS2_LIGHT);
            }
            TabPanelHeaderSubPanel.this.isMouseOver = true;
            TabPanelHeaderSubPanel.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (TabPanelHeaderSubPanel.this.crossLabel.getIcon() == IC_CROSS2_DARK) {
                TabPanelHeaderSubPanel.this.crossLabel.setIcon(IC_CROSS1_DARK);
            } else if (TabPanelHeaderSubPanel.this.crossLabel.getIcon() == IC_CROSS2_LIGHT) {
                TabPanelHeaderSubPanel.this.crossLabel.setIcon(IC_CROSS1_LIGHT);
            }
            TabPanelHeaderSubPanel.this.isMouseOver = false;
            TabPanelHeaderSubPanel.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                TabPanelHeaderSubPanel.this.callback.closeRequested(TabPanelHeaderSubPanel.this.model);
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                TabPanelHeaderSubPanel.this.callback.closeRequested(TabPanelHeaderSubPanel.this.model);
            }
        }
    };

    public TabPanelHeaderSubPanel(TabPanelModel.TabModel tabModel, Callback callback) {
        this.model = tabModel;
        this.callback = callback;
        this.addMouseListener(this.mouseAdapter);
        this.descLabel = new JLabel();
        this.descLabel.setIconTextGap(6);
        this.descLabel.setText(tabModel.title);
        this.descLabel.setIcon(tabModel.icon);
        this.crossLabel = new JLabel(IC_CROSS1_DARK);
        this.crossLabel.setVisible(tabModel.closable);
        this.crossLabel.addMouseListener(this.crossMouseAdapter);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add(Box.createHorizontalStrut(12), "West");
        jPanel.add((Component)this.crossLabel, "Center");
        this.setLayout(new BorderLayout());
        this.add(Box.createHorizontalStrut(6), "West");
        this.add((Component)this.descLabel, "Center");
        this.add((Component)jPanel, "East");
    }

    public TabPanelModel.TabModel getModel() {
        return this.model;
    }

    public void reload() {
        int n;
        this.descLabel.setText(this.model.title);
        this.descLabel.setIcon(this.model.icon);
        this.crossLabel.setVisible(this.model.closable);
        if (this.model.selected) {
            this.descLabel.setForeground(this.foregroundSelected);
            n = PaintUtils.getBrightness(this.fillSelected);
        } else if (this.isMouseOver) {
            this.descLabel.setForeground(this.foregroundMouseOver);
            n = PaintUtils.getBrightness(this.fillMouseOver);
        } else {
            this.descLabel.setForeground(this.foregroundUnselected);
            n = PaintUtils.getBrightness(this.fillUnselected);
        }
        if (n < 128) {
            this.crossLabel.setIcon(IC_CROSS1_LIGHT);
        } else {
            this.crossLabel.setIcon(IC_CROSS1_DARK);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.model.selected) {
            if (this.fillSelected != null) {
                graphics2D.setPaint(PaintUtils.buildPaint(this.fillSelected, n, n2));
                graphics2D.fillRect(0, 0, n, n2);
            }
            if (this.strokeSelected != null) {
                graphics2D.setColor(this.strokeSelected);
                graphics2D.drawLine(0, 0, n - 1, 0);
                graphics2D.drawLine(0, 0, 0, n2 - 1);
                graphics2D.drawLine(n - 1, 0, n - 1, n2 - 1);
            }
        } else if (this.isMouseOver) {
            if (this.fillMouseOver != null) {
                graphics2D.setPaint(PaintUtils.buildPaint(this.fillMouseOver, n, n2));
                graphics2D.fillRect(0, 0, n, n2);
            }
            if (this.strokeMouseOver != null) {
                graphics2D.setColor(this.strokeMouseOver);
                graphics2D.drawLine(0, 0, n - 1, 0);
                graphics2D.drawLine(0, 0, 0, n2 - 1);
                graphics2D.drawLine(n - 1, 0, n - 1, n2 - 1);
            }
            if (this.stroke != null) {
                graphics2D.setColor(this.strokeUnselected);
                graphics2D.drawLine(0, n2 - 1, n - 1, n2 - 1);
            }
        } else {
            if (this.fillUnselected != null) {
                graphics2D.setPaint(PaintUtils.buildPaint(this.fillUnselected, n, n2));
                graphics2D.fillRect(0, 0, n, n2);
            }
            if (this.strokeUnselected != null) {
                graphics2D.setColor(this.strokeUnselected);
                graphics2D.drawLine(0, 0, n - 1, 0);
                graphics2D.drawLine(0, 0, 0, n2 - 1);
                graphics2D.drawLine(n - 1, 0, n - 1, n2 - 1);
            }
            if (this.stroke != null) {
                graphics2D.setColor(this.strokeUnselected);
                graphics2D.drawLine(0, n2 - 1, n - 1, n2 - 1);
            }
        }
    }

    private class PopupMenu
    extends JPopupMenu {
        private final Action closeAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelHeaderSubPanel.this.callback.closeRequested(TabPanelHeaderSubPanel.this.model);
            }
        };
        private final Action closeAllAction = new AbstractAction("Close all"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelHeaderSubPanel.this.callback.closeAllRequested();
            }
        };
        private final Action closeOthersAction = new AbstractAction("Close others"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabPanelHeaderSubPanel.this.callback.closeOthersRequested(TabPanelHeaderSubPanel.this.model);
            }
        };

        public PopupMenu() {
            this.add(this.closeAction);
            this.add(this.closeAllAction);
            this.add(this.closeOthersAction);
        }
    }

    public static interface Callback {
        public void selectRequested(TabPanelModel.TabModel var1);

        public void closeRequested(TabPanelModel.TabModel var1);

        public void closeAllRequested();

        public void closeOthersRequested(TabPanelModel.TabModel var1);
    }
}

