/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.AruiRules;
import aurelienribon.ui.components.TabPanelHeaderSubPanel;
import aurelienribon.ui.components.TabPanelModel;
import aurelienribon.ui.css.Style;
import aurelienribon.ui.css.StyleProcessor;
import aurelienribon.ui.css.StyleRuleSet;
import aurelienribon.ui.css.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;

class TabPanelHeaderPanel
extends JLayeredPane {
    public static final StyleProcessor PROCESSOR = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof TabPanelHeaderPanel) {
                TabPanelHeaderPanel tabPanelHeaderPanel = (TabPanelHeaderPanel)object;
                if (styleRuleSet.contains(AruiRules.STROKE)) {
                    tabPanelHeaderPanel.stroke = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE), 0);
                }
                tabPanelHeaderPanel.styleAttrs = styleRuleSet;
                for (TabPanelHeaderSubPanel tabPanelHeaderSubPanel : tabPanelHeaderPanel.subPanels) {
                    Style.apply((Object)tabPanelHeaderSubPanel, styleRuleSet);
                }
                tabPanelHeaderPanel.reload();
            }
        }
    };
    private static final int MAX_HEIGHT = 20;
    private static final int MIN_HEIGHT = 1;
    private static final int OVERLAP = 1;
    private static final int SELECTED_LAYER = Integer.MAX_VALUE;
    private final List<TabPanelHeaderSubPanel> subPanels = new ArrayList<TabPanelHeaderSubPanel>();
    private final Callback callback;
    private int tabsLayout;
    private StyleRuleSet styleAttrs;
    private Color stroke = Color.RED;

    public TabPanelHeaderPanel(int n, Callback callback) {
        this.tabsLayout = n;
        this.callback = callback;
        this.setOpaque(false);
        this.setHeight(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                TabPanelHeaderPanel.this.reload();
            }
        });
    }

    public void setTabsLayout(int n) {
        this.tabsLayout = n;
        this.reload();
    }

    public int getTabsLayout() {
        return this.tabsLayout;
    }

    public void addTab(TabPanelModel.TabModel tabModel) {
        TabPanelHeaderSubPanel tabPanelHeaderSubPanel = new TabPanelHeaderSubPanel(tabModel, new TabPanelHeaderSubPanel.Callback(){

            @Override
            public void selectRequested(TabPanelModel.TabModel tabModel) {
                TabPanelHeaderPanel.this.callback.selectTabRequested(tabModel);
            }

            @Override
            public void closeRequested(TabPanelModel.TabModel tabModel) {
                TabPanelHeaderPanel.this.callback.closeTabRequested(tabModel);
                TabPanelHeaderPanel.this.reload();
            }

            @Override
            public void closeAllRequested() {
                TabPanelHeaderPanel.this.callback.closeAllTabsRequested();
                TabPanelHeaderPanel.this.reload();
            }

            @Override
            public void closeOthersRequested(TabPanelModel.TabModel tabModel) {
                TabPanelHeaderPanel.this.callback.closeOtherTabsRequested(tabModel);
                TabPanelHeaderPanel.this.reload();
            }
        });
        this.add(tabPanelHeaderSubPanel);
        this.subPanels.add(tabPanelHeaderSubPanel);
        this.reload();
        this.setHeight(20);
        if (this.styleAttrs != null) {
            Style.apply((Object)tabPanelHeaderSubPanel, this.styleAttrs);
        }
    }

    public void removeTab(TabPanelModel.TabModel tabModel) {
        TabPanelHeaderSubPanel tabPanelHeaderSubPanel = this.findSubPanel(tabModel);
        this.subPanels.remove(tabPanelHeaderSubPanel);
        this.remove(tabPanelHeaderSubPanel);
        if (this.subPanels.isEmpty()) {
            this.setHeight(1);
        }
        this.revalidate();
        this.repaint();
    }

    public void removeAllTabs() {
        this.subPanels.clear();
        this.removeAll();
        this.setHeight(1);
        this.revalidate();
        this.repaint();
    }

    public void reload() {
        int n;
        int n2;
        int n3 = this.tabsLayout;
        if (n3 == 0) {
            n2 = 1;
            for (n = 0; n < this.subPanels.size(); ++n) {
                n2 += this.subPanels.get((int)n).getPreferredSize().width - 1;
            }
            if (n2 > this.getWidth()) {
                n3 = 1;
            }
        }
        n2 = 0;
        block5: for (n = 0; n < this.subPanels.size(); ++n) {
            TabPanelHeaderSubPanel tabPanelHeaderSubPanel = this.subPanels.get(n);
            this.setLayer(tabPanelHeaderSubPanel, tabPanelHeaderSubPanel.getModel().selected ? Integer.MAX_VALUE : n);
            switch (n3) {
                case 0: {
                    tabPanelHeaderSubPanel.setBounds(n2, 0, tabPanelHeaderSubPanel.getPreferredSize().width, 20);
                    tabPanelHeaderSubPanel.reload();
                    n2 += tabPanelHeaderSubPanel.getPreferredSize().width - 1;
                    continue block5;
                }
                case 1: {
                    int n4 = n < this.subPanels.size() - 1 ? this.getWidth() / this.subPanels.size() : this.getWidth() - n2;
                    tabPanelHeaderSubPanel.setBounds(n2, 0, n4, 20);
                    tabPanelHeaderSubPanel.reload();
                    n2 += tabPanelHeaderSubPanel.getWidth() - 1;
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.stroke != null) {
            graphics.setColor(this.stroke);
            graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        }
    }

    private void setHeight(int n) {
        this.setMinimumSize(new Dimension(20, n));
        this.setPreferredSize(new Dimension(20, n));
        this.setMaximumSize(new Dimension(20, n));
        this.revalidate();
    }

    private TabPanelHeaderSubPanel findSubPanel(TabPanelModel.TabModel tabModel) {
        for (TabPanelHeaderSubPanel tabPanelHeaderSubPanel : this.subPanels) {
            if (tabPanelHeaderSubPanel.getModel() != tabModel) continue;
            return tabPanelHeaderSubPanel;
        }
        return null;
    }

    public static interface Callback {
        public void selectTabRequested(TabPanelModel.TabModel var1);

        public void closeTabRequested(TabPanelModel.TabModel var1);

        public void closeAllTabsRequested();

        public void closeOtherTabsRequested(TabPanelModel.TabModel var1);
    }
}

