/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public class TokenRewriteStream
extends CommonTokenStream {
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    public static final int MIN_TOKEN_INDEX = 0;
    protected Map programs = null;
    protected Map lastRewriteTokenIndexes = null;

    public TokenRewriteStream() {
        this.init();
    }

    protected void init() {
        this.programs = new HashMap();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap();
    }

    public TokenRewriteStream(TokenSource tokenSource) {
        super(tokenSource);
        this.init();
    }

    public TokenRewriteStream(TokenSource tokenSource, int n) {
        super(tokenSource, n);
        this.init();
    }

    public void rollback(int n) {
        this.rollback(DEFAULT_PROGRAM_NAME, n);
    }

    public void rollback(String string, int n) {
        List list = (List)this.programs.get(string);
        if (list != null) {
            this.programs.put(string, list.subList(0, n));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String string) {
        this.rollback(string, 0);
    }

    public void insertAfter(Token token, Object object) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, token, object);
    }

    public void insertAfter(int n, Object object) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, n, object);
    }

    public void insertAfter(String string, Token token, Object object) {
        this.insertAfter(string, token.getTokenIndex(), object);
    }

    public void insertAfter(String string, int n, Object object) {
        this.insertBefore(string, n + 1, object);
    }

    public void insertBefore(Token token, Object object) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, token, object);
    }

    public void insertBefore(int n, Object object) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, n, object);
    }

    public void insertBefore(String string, Token token, Object object) {
        this.insertBefore(string, token.getTokenIndex(), object);
    }

    public void insertBefore(String string, int n, Object object) {
        InsertBeforeOp insertBeforeOp = new InsertBeforeOp(n, object);
        List list = this.getProgram(string);
        insertBeforeOp.instructionIndex = list.size();
        list.add(insertBeforeOp);
    }

    public void replace(int n, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, n, n, object);
    }

    public void replace(int n, int n2, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, n, n2, object);
    }

    public void replace(Token token, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token, object);
    }

    public void replace(Token token, Token token2, Object object) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token2, object);
    }

    public void replace(String string, int n, int n2, Object object) {
        if (n > n2 || n < 0 || n2 < 0 || n2 >= this.tokens.size()) {
            throw new IllegalArgumentException("replace: range invalid: " + n + ".." + n2 + "(size=" + this.tokens.size() + ")");
        }
        ReplaceOp replaceOp = new ReplaceOp(n, n2, object);
        List list = this.getProgram(string);
        replaceOp.instructionIndex = list.size();
        list.add(replaceOp);
    }

    public void replace(String string, Token token, Token token2, Object object) {
        this.replace(string, token.getTokenIndex(), token2.getTokenIndex(), object);
    }

    public void delete(int n) {
        this.delete(DEFAULT_PROGRAM_NAME, n, n);
    }

    public void delete(int n, int n2) {
        this.delete(DEFAULT_PROGRAM_NAME, n, n2);
    }

    public void delete(Token token) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token);
    }

    public void delete(Token token, Token token2) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token2);
    }

    public void delete(String string, int n, int n2) {
        this.replace(string, n, n2, null);
    }

    public void delete(String string, Token token, Token token2) {
        this.replace(string, token, token2, null);
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String string) {
        Integer n = (Integer)this.lastRewriteTokenIndexes.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    protected void setLastRewriteTokenIndex(String string, int n) {
        this.lastRewriteTokenIndexes.put(string, new Integer(n));
    }

    protected List getProgram(String string) {
        List list = (List)this.programs.get(string);
        if (list == null) {
            list = this.initializeProgram(string);
        }
        return list;
    }

    private List initializeProgram(String string) {
        ArrayList arrayList = new ArrayList(100);
        this.programs.put(string, arrayList);
        return arrayList;
    }

    public String toOriginalString() {
        this.fill();
        return this.toOriginalString(0, this.size() - 1);
    }

    public String toOriginalString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i >= 0 && i <= n2 && i < this.tokens.size(); ++i) {
            if (this.get(i).getType() == -1) continue;
            stringBuffer.append(this.get(i).getText());
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        this.fill();
        return this.toString(0, this.size() - 1);
    }

    public String toString(String string) {
        this.fill();
        return this.toString(string, 0, this.size() - 1);
    }

    @Override
    public String toString(int n, int n2) {
        return this.toString(DEFAULT_PROGRAM_NAME, n, n2);
    }

    public String toString(String string, int n, int n2) {
        List list = (List)this.programs.get(string);
        if (n2 > this.tokens.size() - 1) {
            n2 = this.tokens.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (list == null || list.size() == 0) {
            return this.toOriginalString(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        Map map = this.reduceToSingleOperationPerIndex(list);
        int n3 = n;
        while (n3 <= n2 && n3 < this.tokens.size()) {
            RewriteOperation rewriteOperation = (RewriteOperation)map.get(new Integer(n3));
            map.remove(new Integer(n3));
            Object object = (Token)this.tokens.get(n3);
            if (rewriteOperation == null) {
                if (object.getType() != -1) {
                    stringBuffer.append(object.getText());
                }
                ++n3;
                continue;
            }
            n3 = rewriteOperation.execute(stringBuffer);
        }
        if (n2 == this.tokens.size() - 1) {
            for (Object object : map.values()) {
                if (((RewriteOperation)object).index < this.tokens.size() - 1) continue;
                stringBuffer.append(((RewriteOperation)object).text);
            }
        }
        return stringBuffer.toString();
    }

    protected Map reduceToSingleOperationPerIndex(List list) {
        ReplaceOp replaceOp;
        int n;
        List list2;
        List list3;
        RewriteOperation rewriteOperation;
        RewriteOperation rewriteOperation2;
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            rewriteOperation2 = (RewriteOperation)list.get(n2);
            if (rewriteOperation2 == null || !(rewriteOperation2 instanceof ReplaceOp)) continue;
            rewriteOperation = (ReplaceOp)list.get(n2);
            list3 = this.getKindOfOps(list, InsertBeforeOp.class, n2);
            for (int i = 0; i < list3.size(); ++i) {
                InsertBeforeOp insertBeforeOp = (InsertBeforeOp)list3.get(i);
                if (insertBeforeOp.index == rewriteOperation.index) {
                    list.set(insertBeforeOp.instructionIndex, null);
                    rewriteOperation.text = insertBeforeOp.text.toString() + (rewriteOperation.text != null ? rewriteOperation.text.toString() : "");
                    continue;
                }
                if (insertBeforeOp.index <= rewriteOperation.index || insertBeforeOp.index > rewriteOperation.lastIndex) continue;
                list.set(insertBeforeOp.instructionIndex, null);
            }
            list2 = this.getKindOfOps(list, ReplaceOp.class, n2);
            for (n = 0; n < list2.size(); ++n) {
                boolean bl;
                replaceOp = (ReplaceOp)list2.get(n);
                if (replaceOp.index >= rewriteOperation.index && replaceOp.lastIndex <= rewriteOperation.lastIndex) {
                    list.set(replaceOp.instructionIndex, null);
                    continue;
                }
                boolean bl2 = replaceOp.lastIndex < rewriteOperation.index || replaceOp.index > rewriteOperation.lastIndex;
                boolean bl3 = bl = replaceOp.index == rewriteOperation.index && replaceOp.lastIndex == rewriteOperation.lastIndex;
                if (replaceOp.text == null && rewriteOperation.text == null && !bl2) {
                    list.set(replaceOp.instructionIndex, null);
                    rewriteOperation.index = Math.min(replaceOp.index, rewriteOperation.index);
                    rewriteOperation.lastIndex = Math.max(replaceOp.lastIndex, rewriteOperation.lastIndex);
                    System.out.println("new rop " + rewriteOperation);
                    continue;
                }
                if (bl2 || bl) continue;
                throw new IllegalArgumentException("replace op boundaries of " + rewriteOperation + " overlap with previous " + replaceOp);
            }
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            rewriteOperation2 = (RewriteOperation)list.get(n2);
            if (rewriteOperation2 == null || !(rewriteOperation2 instanceof InsertBeforeOp)) continue;
            rewriteOperation = (InsertBeforeOp)list.get(n2);
            list3 = this.getKindOfOps(list, InsertBeforeOp.class, n2);
            for (int i = 0; i < list3.size(); ++i) {
                InsertBeforeOp insertBeforeOp = (InsertBeforeOp)list3.get(i);
                if (insertBeforeOp.index != ((InsertBeforeOp)rewriteOperation).index) continue;
                ((InsertBeforeOp)rewriteOperation).text = this.catOpText(((InsertBeforeOp)rewriteOperation).text, insertBeforeOp.text);
                list.set(insertBeforeOp.instructionIndex, null);
            }
            list2 = this.getKindOfOps(list, ReplaceOp.class, n2);
            for (n = 0; n < list2.size(); ++n) {
                replaceOp = (ReplaceOp)list2.get(n);
                if (((InsertBeforeOp)rewriteOperation).index == replaceOp.index) {
                    replaceOp.text = this.catOpText(((InsertBeforeOp)rewriteOperation).text, replaceOp.text);
                    list.set(n2, null);
                    continue;
                }
                if (((InsertBeforeOp)rewriteOperation).index < replaceOp.index || ((InsertBeforeOp)rewriteOperation).index > replaceOp.lastIndex) continue;
                throw new IllegalArgumentException("insert op " + rewriteOperation + " within boundaries of previous " + replaceOp);
            }
        }
        HashMap<Integer, ReplaceOp> hashMap = new HashMap<Integer, ReplaceOp>();
        for (int i = 0; i < list.size(); ++i) {
            rewriteOperation = (RewriteOperation)list.get(i);
            if (rewriteOperation == null) continue;
            if (hashMap.get(new Integer(rewriteOperation.index)) != null) {
                throw new Error("should only be one op per index");
            }
            hashMap.put(new Integer(rewriteOperation.index), (ReplaceOp)rewriteOperation);
        }
        return hashMap;
    }

    protected String catOpText(Object object, Object object2) {
        String string = "";
        String string2 = "";
        if (object != null) {
            string = object.toString();
        }
        if (object2 != null) {
            string2 = object2.toString();
        }
        return string + string2;
    }

    protected List getKindOfOps(List list, Class clazz) {
        return this.getKindOfOps(list, clazz, list.size());
    }

    protected List getKindOfOps(List list, Class clazz, int n) {
        ArrayList<RewriteOperation> arrayList = new ArrayList<RewriteOperation>();
        for (int i = 0; i < n && i < list.size(); ++i) {
            RewriteOperation rewriteOperation = (RewriteOperation)list.get(i);
            if (rewriteOperation == null || rewriteOperation.getClass() != clazz) continue;
            arrayList.add(rewriteOperation);
        }
        return arrayList;
    }

    public String toDebugString() {
        return this.toDebugString(0, this.size() - 1);
    }

    public String toDebugString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i >= 0 && i <= n2 && i < this.tokens.size(); ++i) {
            stringBuffer.append(this.get(i));
        }
        return stringBuffer.toString();
    }

    class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int n, int n2, Object object) {
            super(n, object);
            this.lastIndex = n2;
        }

        @Override
        public int execute(StringBuffer stringBuffer) {
            if (this.text != null) {
                stringBuffer.append(this.text);
            }
            return this.lastIndex + 1;
        }

        @Override
        public String toString() {
            if (this.text == null) {
                return "<DeleteOp@" + TokenRewriteStream.this.tokens.get(this.index) + ".." + TokenRewriteStream.this.tokens.get(this.lastIndex) + ">";
            }
            return "<ReplaceOp@" + TokenRewriteStream.this.tokens.get(this.index) + ".." + TokenRewriteStream.this.tokens.get(this.lastIndex) + ":\"" + this.text + "\">";
        }
    }

    class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int n, Object object) {
            super(n, object);
        }

        @Override
        public int execute(StringBuffer stringBuffer) {
            stringBuffer.append(this.text);
            if (((Token)TokenRewriteStream.this.tokens.get(this.index)).getType() != -1) {
                stringBuffer.append(((Token)TokenRewriteStream.this.tokens.get(this.index)).getText());
            }
            return this.index + 1;
        }
    }

    class RewriteOperation {
        protected int instructionIndex;
        protected int index;
        protected Object text;

        protected RewriteOperation(int n) {
            this.index = n;
        }

        protected RewriteOperation(int n, Object object) {
            this.index = n;
            this.text = object;
        }

        public int execute(StringBuffer stringBuffer) {
            return this.index;
        }

        public String toString() {
            String string = this.getClass().getName();
            int n = string.indexOf(36);
            string = string.substring(n + 1, string.length());
            return "<" + string + "@" + TokenRewriteStream.this.tokens.get(this.index) + ":\"" + this.text + "\">";
        }
    }
}

