/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css.swing;

import aurelienribon.ui.css.StyleProcessor;
import aurelienribon.ui.css.StyleRuleSet;
import aurelienribon.ui.css.swing.SwingRules;
import aurelienribon.ui.css.swing.SwingUtils;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class SwingProcessors {
    public static final StyleProcessor COMPONENT = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof Component) {
                Component component = (Component)object;
                if (styleRuleSet.contains(SwingRules.BACKGROUND)) {
                    component.setBackground(SwingUtils.asColor(styleRuleSet.getParams(SwingRules.BACKGROUND), 0));
                }
                if (styleRuleSet.contains(SwingRules.FOREGROUND)) {
                    component.setForeground(SwingUtils.asColor(styleRuleSet.getParams(SwingRules.FOREGROUND), 0));
                }
                if (styleRuleSet.contains(SwingRules.VISIBLE)) {
                    component.setVisible(styleRuleSet.asBoolean(SwingRules.VISIBLE, 0));
                }
                if (styleRuleSet.contains(SwingRules.ENABLED)) {
                    component.setEnabled(styleRuleSet.asBoolean(SwingRules.ENABLED, 0));
                }
                if (styleRuleSet.contains(SwingRules.FOCUSABLE)) {
                    component.setFocusable(styleRuleSet.asBoolean(SwingRules.FOCUSABLE, 0));
                }
                if (styleRuleSet.contains(SwingRules.FONT)) {
                    component.setFont(SwingUtils.asFont(styleRuleSet.getParams(SwingRules.FONT)));
                }
            }
        }
    };
    public static final StyleProcessor JCOMPONENT = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                if (styleRuleSet.contains(SwingRules.OPAQUE)) {
                    jComponent.setOpaque(styleRuleSet.asBoolean(SwingRules.OPAQUE, 0));
                }
                if (styleRuleSet.contains(SwingRules.TOOLTIP)) {
                    jComponent.setToolTipText(styleRuleSet.asString(SwingRules.TOOLTIP, 0));
                }
                if (styleRuleSet.contains(SwingRules.BORDER)) {
                    jComponent.setBorder(SwingUtils.asBorder(styleRuleSet.getParams(SwingRules.BORDER), 0));
                }
            }
        }
    };
    public static final StyleProcessor ABSTRACTBUTTON = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                if (styleRuleSet.contains(SwingRules.MARGIN)) {
                    abstractButton.setMargin(SwingUtils.asInsets(styleRuleSet.getParams(SwingRules.MARGIN)));
                }
                if (styleRuleSet.contains(SwingRules.H_ALIGN)) {
                    abstractButton.setHorizontalAlignment(SwingUtils.asHAlign(styleRuleSet.getParams(SwingRules.H_ALIGN), 0));
                }
                if (styleRuleSet.contains(SwingRules.V_ALIGN)) {
                    abstractButton.setVerticalAlignment(SwingUtils.asVAlign(styleRuleSet.getParams(SwingRules.V_ALIGN), 0));
                }
                if (styleRuleSet.contains(SwingRules.TEXT)) {
                    abstractButton.setText(styleRuleSet.asString(SwingRules.TEXT, 0));
                }
                if (styleRuleSet.contains(SwingRules.ICON)) {
                    abstractButton.setIcon(SwingUtils.asIcon(styleRuleSet.getParams(SwingRules.ICON), 0));
                }
            }
        }
    };
    public static final StyleProcessor JLABEL = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof JLabel) {
                JLabel jLabel = (JLabel)object;
                if (styleRuleSet.contains(SwingRules.H_ALIGN)) {
                    jLabel.setHorizontalAlignment(SwingUtils.asHAlign(styleRuleSet.getParams(SwingRules.H_ALIGN), 0));
                }
                if (styleRuleSet.contains(SwingRules.V_ALIGN)) {
                    jLabel.setVerticalAlignment(SwingUtils.asVAlign(styleRuleSet.getParams(SwingRules.V_ALIGN), 0));
                }
                if (styleRuleSet.contains(SwingRules.TEXT)) {
                    jLabel.setText(styleRuleSet.asString(SwingRules.TEXT, 0));
                }
                if (styleRuleSet.contains(SwingRules.ICON)) {
                    jLabel.setIcon(SwingUtils.asIcon(styleRuleSet.getParams(SwingRules.ICON), 0));
                }
            }
        }
    };
    public static final StyleProcessor JTEXTCOMPONENT = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)object;
                if (styleRuleSet.contains(SwingRules.CARETPOSITION)) {
                    jTextComponent.setCaretPosition(styleRuleSet.asInteger(SwingRules.CARETPOSITION, 0));
                }
                if (styleRuleSet.contains(SwingRules.EDITABLE)) {
                    jTextComponent.setEditable(styleRuleSet.asBoolean(SwingRules.EDITABLE, 0));
                }
                if (styleRuleSet.contains(SwingRules.MARGIN)) {
                    jTextComponent.setMargin(SwingUtils.asInsets(styleRuleSet.getParams(SwingRules.MARGIN)));
                }
                if (styleRuleSet.contains(SwingRules.TEXT)) {
                    jTextComponent.setText(styleRuleSet.asString(SwingRules.TEXT, 0));
                }
            }
        }
    };
    public static final StyleProcessor JTEXTAREA = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)object;
                if (styleRuleSet.contains(SwingRules.LINEWRAP)) {
                    jTextArea.setLineWrap(styleRuleSet.asBoolean(SwingRules.LINEWRAP, 0));
                }
                if (styleRuleSet.contains(SwingRules.WRAPSTYLEWORD)) {
                    jTextArea.setWrapStyleWord(styleRuleSet.asBoolean(SwingRules.WRAPSTYLEWORD, 0));
                }
                if (styleRuleSet.contains(SwingRules.TABSIZE)) {
                    jTextArea.setTabSize(styleRuleSet.asInteger(SwingRules.TABSIZE, 0));
                }
            }
        }
    };
}

