/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css.swing;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;

public class PaintUtils {
    public static int getBrightness(Color color) {
        if (color == null) {
            return -1;
        }
        return (int)Math.sqrt((double)(color.getRed() * color.getRed()) * 0.241 + (double)(color.getGreen() * color.getGreen()) * 0.691 + (double)(color.getBlue() * color.getBlue()) * 0.068);
    }

    public static int getBrightness(Paint paint) {
        if (paint == null) {
            return -1;
        }
        if (paint instanceof Color) {
            return PaintUtils.getBrightness((Color)paint);
        }
        if (paint instanceof MultipleGradientPaint) {
            MultipleGradientPaint multipleGradientPaint = (MultipleGradientPaint)paint;
            int n = 128;
            for (Color color : multipleGradientPaint.getColors()) {
                n += PaintUtils.getBrightness(color);
            }
            return n / multipleGradientPaint.getColors().length;
        }
        assert (false);
        return -1;
    }

    public static Paint buildPaint(Paint paint, int n, int n2) {
        if (paint instanceof Color) {
            return paint;
        }
        if (paint instanceof LinearGradientPaint) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)paint;
            float f = (float)(linearGradientPaint.getStartPoint().getX() * (double)n);
            float f2 = (float)(linearGradientPaint.getStartPoint().getY() * (double)n2);
            float f3 = (float)(linearGradientPaint.getEndPoint().getX() * (double)n);
            float f4 = (float)(linearGradientPaint.getEndPoint().getY() * (double)n2);
            return new LinearGradientPaint(f, f2, f3, f4, linearGradientPaint.getFractions(), linearGradientPaint.getColors());
        }
        assert (false);
        return null;
    }
}

