/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css;

import aurelienribon.ui.css.CssLexer;
import aurelienribon.ui.css.CssParser;
import aurelienribon.ui.css.StyleChildrenAccessor;
import aurelienribon.ui.css.StyleClass;
import aurelienribon.ui.css.StyleException;
import aurelienribon.ui.css.StyleFunction;
import aurelienribon.ui.css.StyleParamConverter;
import aurelienribon.ui.css.StyleProcessor;
import aurelienribon.ui.css.StyleRule;
import aurelienribon.ui.css.StyleRuleSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;

public class Style {
    private static final Map<String, StyleRule> registeredRules = new LinkedHashMap<String, StyleRule>();
    private static final Map<String, StyleFunction> registeredFunctions = new LinkedHashMap<String, StyleFunction>();
    private static final List<StyleProcessor> registeredProcessors = new ArrayList<StyleProcessor>();
    private static final Map<Object, String> registeredTargetsClassNames = new LinkedHashMap<Object, String>();
    private static final List<Class> registeredSkippedClasses = new ArrayList<Class>();
    private static final Map<Class, StyleChildrenAccessor> registeredChildrenAccessors = new HashMap<Class, StyleChildrenAccessor>();
    private static StyleParamConverter converter;
    private final String styleSheet;
    private final List<StyleClass> classes = new ArrayList<StyleClass>();

    public static void registerRule(StyleRule styleRule) {
        if (registeredRules.containsKey(styleRule.getName())) {
            throw new RuntimeException("Rule already registered");
        }
        registeredRules.put(styleRule.getName(), styleRule);
    }

    public static void registerFunction(StyleFunction styleFunction) {
        if (registeredFunctions.containsKey(styleFunction.getName())) {
            throw new RuntimeException("Function already registered");
        }
        registeredFunctions.put(styleFunction.getName(), styleFunction);
    }

    public static void registerProcessor(StyleProcessor styleProcessor) {
        for (StyleProcessor styleProcessor2 : registeredProcessors) {
            if (styleProcessor2.getClass() != styleProcessor.getClass()) continue;
            throw new RuntimeException("Processor already registered");
        }
        registeredProcessors.add(styleProcessor);
    }

    public static void registerTargetClassName(Object object, String string) {
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        registeredTargetsClassNames.put(object, string);
    }

    public static void registerSkippedClass(Class clazz) {
        if (registeredSkippedClasses.contains(clazz)) {
            throw new RuntimeException("Skipped class already registered");
        }
        registeredSkippedClasses.add(clazz);
    }

    public static void registerChildrenAccessor(Class clazz, StyleChildrenAccessor styleChildrenAccessor) {
        if (registeredChildrenAccessors.containsKey(clazz)) {
            throw new RuntimeException("Accessor already registered");
        }
        registeredChildrenAccessors.put(clazz, styleChildrenAccessor);
    }

    public static void unregisterRule(StyleRule styleRule) {
        registeredRules.remove(styleRule.getName());
    }

    public static void unregisterFunction(StyleFunction styleFunction) {
        registeredFunctions.remove(styleFunction.getName());
    }

    public static void unregisterProcessor(StyleProcessor styleProcessor) {
        registeredProcessors.remove(styleProcessor);
    }

    public static void unregisterTargetClassName(Object object) {
        registeredTargetsClassNames.remove(object);
    }

    public static void unregisterSkippedClass(Class clazz) {
        registeredSkippedClasses.remove(clazz);
    }

    public static void unregisterChildrenAccessor(Class clazz) {
        registeredChildrenAccessors.remove(clazz);
    }

    public static void apply(Object object, Style style) {
        Style.apply(object, style, new ArrayList<String>());
    }

    public static void apply(Object object, StyleRuleSet styleRuleSet) {
        for (StyleProcessor styleProcessor : registeredProcessors) {
            styleProcessor.process(object, styleRuleSet);
        }
    }

    public static void setParamConverter(StyleParamConverter styleParamConverter) {
        converter = styleParamConverter;
    }

    public static List<String> getRegisteredRulesNames() {
        return Collections.unmodifiableList(new ArrayList<String>(registeredRules.keySet()));
    }

    public static StyleRule getRegisteredRule(String string) {
        return registeredRules.get(string);
    }

    public static List<String> getRegisteredFunctionsNames() {
        return Collections.unmodifiableList(new ArrayList<String>(registeredFunctions.keySet()));
    }

    public static StyleFunction getRegisteredFunction(String string) {
        return registeredFunctions.get(string);
    }

    public static List<StyleProcessor> getRegisteredProcessors() {
        return Collections.unmodifiableList(registeredProcessors);
    }

    public static List<Object> getRegisteredTargets() {
        return Collections.unmodifiableList(new ArrayList<Object>(registeredTargetsClassNames.keySet()));
    }

    public static String getRegisteredTargetClassName(Object object) {
        return registeredTargetsClassNames.get(object);
    }

    public static String getRulesManual() {
        return Style.generateManual(registeredRules.values());
    }

    public static String getFunctionsManual() {
        return Style.generateManual(registeredFunctions.values());
    }

    public Style(URL uRL) throws StyleException {
        this.styleSheet = Style.getStyleSheet(uRL);
        this.parse(this.styleSheet);
    }

    public Style(String string) throws StyleException {
        this.styleSheet = string;
        this.parse(string);
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public List<StyleClass> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStyleSheet(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("styleSheetUrl");
        }
        BufferedReader bufferedReader = null;
        try {
            int n;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[4096];
            while ((n = bufferedReader.read(cArray)) > -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void parse(String string) throws StyleException {
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream(string);
        CssLexer cssLexer = new CssLexer(aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream();
        commonTokenStream.setTokenSource(cssLexer);
        CssParser cssParser = new CssParser(commonTokenStream);
        try {
            Map<String, Map<String, List<Object>>> map = cssParser.stylesheet();
            for (String string2 : map.keySet()) {
                Map<String, List<Object>> map2 = map.get(string2);
                ArrayList<StyleRule> arrayList = new ArrayList<StyleRule>();
                HashMap<StyleRule, List<Object>> hashMap = new HashMap<StyleRule, List<Object>>();
                for (String string3 : map2.keySet()) {
                    StyleRule styleRule = registeredRules.get(string3);
                    List<Object> list = map2.get(string3);
                    if (styleRule == null) {
                        throw StyleException.forRule(string3);
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, Style.evaluateParam(list.get(i)));
                    }
                    if (!Style.checkParams(styleRule, list)) {
                        throw StyleException.forRuleParams(styleRule);
                    }
                    arrayList.add(styleRule);
                    hashMap.put(styleRule, list);
                }
                StyleRuleSet styleRuleSet = new StyleRuleSet(arrayList, hashMap);
                StyleClass object2 = new StyleClass(string2, styleRuleSet);
                this.classes.add(object2);
            }
        }
        catch (RecognitionException recognitionException) {
            throw new StyleException(recognitionException.getMessage());
        }
    }

    private static Object evaluateParam(Object object) throws StyleException {
        Object object2;
        if (object instanceof CssParser.Color) {
            object2 = (CssParser.Color)object;
            if (converter != null) {
                return converter.convertColor(((CssParser.Color)object2).r, ((CssParser.Color)object2).g, ((CssParser.Color)object2).b, ((CssParser.Color)object2).a);
            }
        }
        if (object instanceof CssParser.Function) {
            object2 = (CssParser.Function)object;
            StyleFunction styleFunction = registeredFunctions.get(((CssParser.Function)object2).name);
            ArrayList<Object> arrayList = new ArrayList<Object>(((CssParser.Function)object2).params);
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.set(i, Style.evaluateParam(arrayList.get(i)));
            }
            if (styleFunction == null) {
                throw StyleException.forFunction(((CssParser.Function)object2).name);
            }
            if (!Style.checkParams(styleFunction, arrayList)) {
                throw StyleException.forFunctionParams(styleFunction);
            }
            return styleFunction.process(arrayList);
        }
        return object;
    }

    private static boolean checkParams(StyleRule styleRule, List<Object> list) {
        for (int i = 0; i < styleRule.getParams().length; ++i) {
            int n;
            Class[] classArray = styleRule.getParams()[i];
            if (list.size() != classArray.length) continue;
            boolean bl = true;
            for (n = 0; n < list.size(); ++n) {
                assert (classArray[n] != null);
                if (classArray[n].isInstance(list.get(n)) || list.get(n) == null && styleRule.canBeNull(i, n)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            for (n = 0; n < list.size(); ++n) {
                String[] stringArray = styleRule.getKeywords(i, n);
                if (stringArray == null || Arrays.asList(stringArray).contains((String)list.get(n))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void apply(Object object, Style style, List<String> list) {
        for (Class object2 : registeredSkippedClasses) {
            if (!object2.isInstance(object)) continue;
            return;
        }
        StyleRuleSet styleRuleSet = new StyleRuleSet(style, object, list);
        Style.apply(object, styleRuleSet);
        list.add(object.getClass().getName());
        if (registeredTargetsClassNames.containsKey(object)) {
            list.add(registeredTargetsClassNames.get(object));
        }
        for (Class clazz : registeredChildrenAccessors.keySet()) {
            if (!clazz.isInstance(object)) continue;
            StyleChildrenAccessor styleChildrenAccessor = registeredChildrenAccessors.get(clazz);
            for (Object obj : styleChildrenAccessor.getChildren(object)) {
                Style.apply(obj, style, list);
            }
        }
    }

    private static String generateManual(Collection<? extends StyleRule> collection) {
        String string = "";
        for (StyleRule styleRule : collection) {
            string = string + styleRule.getName() + Style.getReturnStatement(styleRule) + "\n";
            for (int i = 0; i < styleRule.getParams().length; ++i) {
                string = string + "    ";
                if (styleRule.getParams()[i].length == 0) {
                    string = string + "nothing";
                }
                for (int j = 0; j < styleRule.getParams()[i].length; ++j) {
                    String string2 = styleRule.getParams()[i][j].getSimpleName();
                    String string3 = styleRule.getParamsNames()[i][j];
                    if (j > 0) {
                        string = string + ", ";
                    }
                    string = string + Style.prettify(string2) + " " + string3;
                }
                string = string + "\n";
            }
            string = string + "\n";
        }
        return string.trim();
    }

    private static String prettify(String string) {
        string = string.replace("Integer", "int");
        string = string.replace("Float", "float");
        string = string.replace("Number", "float");
        string = string.replace("Boolean", "boolean");
        return string;
    }

    private static String getReturnStatement(StyleRule styleRule) {
        if (styleRule instanceof StyleFunction) {
            StyleFunction styleFunction = (StyleFunction)styleRule;
            return " [returns " + Style.prettify(styleFunction.getReturn().getSimpleName()) + "]";
        }
        return "";
    }
}

