/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;

public class TabPanelModel {
    private final List<TabModel> tabModels = new ArrayList<TabModel>();
    private Callback callback;

    public void add(Component component, String string) {
        this.add(component, string, null, true);
    }

    public void add(Component component, String string, ImageIcon imageIcon) {
        this.add(component, string, imageIcon, true);
    }

    public void add(Component component, String string, ImageIcon imageIcon, boolean bl) {
        TabModel tabModel = new TabModel(component, string, imageIcon, bl);
        this.tabModels.add(tabModel);
        if (this.callback != null) {
            this.callback.tabAdded(tabModel, this.tabModels.indexOf(tabModel));
        }
    }

    public void remove(Component component) {
        this.remove(this.tabModels.indexOf(this.findTabModel(component)));
    }

    public void remove(int n) {
        if (n >= 0 && n < this.tabModels.size()) {
            TabModel tabModel = this.tabModels.remove(n);
            if (this.callback != null) {
                this.callback.tabRemoved(tabModel, n);
            }
        }
    }

    public int getTabsCount() {
        return this.tabModels.size();
    }

    public void setSelection(Component component) {
        this.setSelection(this.tabModels.indexOf(this.findTabModel(component)));
    }

    public void setSelection(int n) {
        for (TabModel tabModel : this.tabModels) {
            tabModel.selected = false;
        }
        if (n >= 0 && n < this.tabModels.size()) {
            TabModel tabModel = this.tabModels.get(n);
            tabModel.selected = true;
            if (this.callback != null) {
                this.callback.selectionChanged(tabModel, n);
            }
        } else if (this.callback != null) {
            this.callback.selectionChanged(null, -1);
        }
    }

    List<TabModel> getTabModels() {
        return Collections.unmodifiableList(this.tabModels);
    }

    void setCallback(Callback callback) {
        this.callback = callback;
    }

    TabModel getSelectedTabModel() {
        for (TabModel tabModel : this.tabModels) {
            if (!tabModel.selected) continue;
            return tabModel;
        }
        return null;
    }

    private TabModel findTabModel(Component component) {
        for (TabModel tabModel : this.tabModels) {
            if (tabModel.component != component) continue;
            return tabModel;
        }
        return null;
    }

    static interface Callback {
        public void tabAdded(TabModel var1, int var2);

        public void tabRemoved(TabModel var1, int var2);

        public void selectionChanged(TabModel var1, int var2);
    }

    class TabModel {
        public final Component component;
        public String title;
        public ImageIcon icon;
        public boolean closable;
        public boolean selected = false;

        public TabModel(Component component, String string, ImageIcon imageIcon, boolean bl) {
            this.component = component;
            this.title = string;
            this.icon = imageIcon;
            this.closable = bl;
        }
    }
}

