/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.AruiRules;
import aurelienribon.ui.components.TabPanelHeaderPanel;
import aurelienribon.ui.components.TabPanelHeaderSubPanel;
import aurelienribon.ui.components.TabPanelModel;
import aurelienribon.ui.components.TransparentPanel;
import aurelienribon.ui.css.Style;
import aurelienribon.ui.css.StyleProcessor;
import aurelienribon.ui.css.StyleRule;
import aurelienribon.ui.css.StyleRuleSet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class TabPanel
extends JPanel {
    public static final StyleProcessor PROCESSOR = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof TabPanel) {
                TabPanel tabPanel = (TabPanel)object;
                styleRuleSet = new StyleRuleSet(styleRuleSet, new StyleRule[]{AruiRules.STROKE, AruiRules.FOREGROUND_UNSELECTED, AruiRules.FOREGROUND_SELECTED, AruiRules.FOREGROUND_MOUSEOVER, AruiRules.STROKE, AruiRules.STROKE_UNSELECTED, AruiRules.STROKE_SELECTED, AruiRules.STROKE_MOUSEOVER, AruiRules.FILL_UNSELECTED, AruiRules.FILL_SELECTED, AruiRules.FILL_MOUSEOVER});
                Style.apply((Object)tabPanel.headerPanel, styleRuleSet);
            }
        }
    };
    public static final int LAYOUT_STACK = 0;
    public static final int LAYOUT_GRID = 1;
    private final Map<TabPanelModel.TabModel, String> cardsMap = new HashMap<TabPanelModel.TabModel, String>();
    private final TabPanelHeaderPanel headerPanel = new TabPanelHeaderPanel(0, new TabHeaderPanelCallbackImpl());
    private final CardLayout cardLayout = new CardLayout();
    private final JPanel cardPanel = new TransparentPanel(this.cardLayout);
    private TabPanelModel model;
    private int cnt = 0;

    public TabPanel() {
        this.setPreferredSize(new Dimension(50, 50));
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.cardPanel, "Center");
        this.setModel(new TabPanelModel());
    }

    public void setHeaderLayout(int n) {
        if (n < 0 || n > 1) {
            return;
        }
        this.headerPanel.setTabsLayout(n);
    }

    public int getHeaderLayout() {
        return this.headerPanel.getTabsLayout();
    }

    public void setModel(final TabPanelModel tabPanelModel) {
        this.cardPanel.removeAll();
        this.headerPanel.removeAllTabs();
        this.model = tabPanelModel;
        tabPanelModel.setCallback(new TabPanelModel.Callback(){

            @Override
            public void tabAdded(TabPanelModel.TabModel tabModel, int n) {
                TabPanel.this.cardsMap.put(tabModel, "card" + TabPanel.this.cnt++);
                TabPanel.this.cardPanel.add(tabModel.component, TabPanel.this.cardsMap.get(tabModel));
                TabPanel.this.headerPanel.addTab(tabModel);
                if (tabPanelModel.getSelectedTabModel() == null) {
                    TabPanel.this.selectLastModel();
                }
            }

            @Override
            public void tabRemoved(TabPanelModel.TabModel tabModel, int n) {
                TabPanel.this.cardsMap.remove(tabModel);
                TabPanel.this.cardPanel.remove(tabModel.component);
                TabPanel.this.headerPanel.removeTab(tabModel);
                if (tabPanelModel.getSelectedTabModel() == null) {
                    TabPanel.this.selectLastModel();
                }
            }

            @Override
            public void selectionChanged(TabPanelModel.TabModel tabModel, int n) {
                TabPanel.this.cardLayout.show(TabPanel.this.cardPanel, (String)TabPanel.this.cardsMap.get(tabModel));
                TabPanel.this.headerPanel.reload();
                if (tabModel != null) {
                    tabModel.component.requestFocusInWindow();
                }
            }
        });
        for (TabPanelModel.TabModel tabModel : tabPanelModel.getTabModels()) {
            this.cardsMap.put(tabModel, "card" + this.cnt++);
            this.cardPanel.add(tabModel.component, this.cardsMap.get(tabModel));
            this.headerPanel.addTab(tabModel);
        }
        if (tabPanelModel.getSelectedTabModel() == null) {
            tabPanelModel.setSelection(0);
        }
    }

    public TabPanelModel getModel() {
        return this.model;
    }

    @Override
    public void setBackground(Color color) {
        if (this.cardPanel != null) {
            this.cardPanel.setBackground(color);
        }
    }

    @Override
    public void setBorder(Border border) {
        if (this.cardPanel != null) {
            this.cardPanel.setBorder(border);
        }
    }

    private void selectModel(TabPanelModel.TabModel tabModel) {
        this.model.setSelection(tabModel != null ? tabModel.component : null);
    }

    private void selectLastModel() {
        if (this.model.getTabModels().isEmpty()) {
            this.selectModel(null);
        } else {
            this.selectModel(this.model.getTabModels().get(this.model.getTabModels().size() - 1));
        }
    }

    static {
        Style.registerSkippedClass(TabPanelHeaderPanel.class);
        Style.registerSkippedClass(TabPanelHeaderSubPanel.class);
    }

    private class TabHeaderPanelCallbackImpl
    implements TabPanelHeaderPanel.Callback {
        private TabHeaderPanelCallbackImpl() {
        }

        @Override
        public void selectTabRequested(TabPanelModel.TabModel tabModel) {
            TabPanel.this.selectModel(tabModel);
        }

        @Override
        public void closeTabRequested(TabPanelModel.TabModel tabModel) {
            if (tabModel.closable) {
                TabPanel.this.model.remove(tabModel.component);
            }
        }

        @Override
        public void closeAllTabsRequested() {
            for (int i = TabPanel.this.model.getTabModels().size() - 1; i >= 0; --i) {
                TabPanelModel.TabModel tabModel = TabPanel.this.model.getTabModels().get(i);
                if (!tabModel.closable) continue;
                TabPanel.this.model.remove(tabModel.component);
            }
        }

        @Override
        public void closeOtherTabsRequested(TabPanelModel.TabModel tabModel) {
            for (int i = TabPanel.this.model.getTabModels().size() - 1; i >= 0; --i) {
                TabPanelModel.TabModel tabModel2 = TabPanel.this.model.getTabModels().get(i);
                if (!tabModel2.closable || tabModel2 == tabModel) continue;
                TabPanel.this.model.remove(tabModel2.component);
            }
        }
    }
}

