/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private BufferedImage background;
    private BufferedImage image;
    private boolean useRegion;
    private int x;
    private int y;
    private int width;
    private int height;

    public void setBackground(URL uRL) {
        try {
            this.background = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clearImage() {
        this.image = null;
        this.repaint();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.repaint();
    }

    public void setImage(File file) {
        this.setImage(file, 0, 0, 0, 0);
        this.useRegion = false;
    }

    public void setImage(URL uRL) {
        this.setImage(uRL, 0, 0, 0, 0);
        this.useRegion = false;
    }

    public void setImage(File file, int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.useRegion = true;
        try {
            this.image = file != null ? ImageIO.read(file) : null;
            this.repaint();
        }
        catch (IOException iOException) {
            Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public void setImage(URL uRL, int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.useRegion = true;
        try {
            this.image = uRL != null ? ImageIO.read(uRL) : null;
            this.repaint();
        }
        catch (IOException iOException) {
            Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.background != null) {
            TexturePaint texturePaint = new TexturePaint(this.background, new Rectangle(0, 0, this.background.getWidth(), this.background.getHeight()));
            graphics2D.setPaint(texturePaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(null);
        }
        if (this.image != null && !this.useRegion) {
            float f = (float)this.getWidth() / (float)this.getHeight();
            float f2 = (float)this.image.getWidth() / (float)this.image.getHeight();
            if (f2 > f) {
                float f3 = this.getWidth();
                float f4 = (float)this.getWidth() / f2;
                graphics2D.drawImage(this.image, 0, (int)((float)(this.getHeight() / 2) - f4 / 2.0f), (int)f3, (int)f4, null);
            } else {
                float f5 = (float)this.getHeight() * f2;
                float f6 = this.getHeight();
                graphics2D.drawImage(this.image, (int)((float)this.getWidth() / 2.0f - f5 / 2.0f), 0, (int)f5, (int)f6, null);
            }
        } else if (this.image != null && this.useRegion) {
            float f = (float)this.width / (float)this.height;
            float f7 = (float)this.getWidth() / (float)this.getHeight();
            if (f > f7) {
                int n = this.getWidth();
                int n2 = (int)((float)this.getWidth() / f);
                int n3 = 0;
                int n4 = this.getHeight() / 2 - n2 / 2;
                graphics2D.drawImage(this.image, n3, n4, n3 + n, n4 + n2, this.x, this.y, this.x + this.width, this.y + this.width, null);
            } else {
                int n = (int)((float)this.getHeight() * f);
                int n5 = this.getHeight();
                int n6 = this.getWidth() / 2 - n / 2;
                int n7 = 0;
                graphics2D.drawImage(this.image, n6, n7, n6 + n, n7 + n5, this.x, this.y, this.x + this.width, this.y + this.width, null);
            }
        }
    }
}

