/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.css.swing.PaintUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class GroupBorder
implements Border {
    private final JLabel label = new JLabel();
    private int titleHeight;
    private int padding;
    private Color stroke;
    private Paint fill;
    private boolean headerStrokeVisible;

    public GroupBorder() {
        this(null, "GroupBorder", 20, 6, Color.BLACK, Color.LIGHT_GRAY, true);
    }

    public GroupBorder(Icon icon, String string, int n, int n2, Color color, Paint paint) {
        this(icon, string, n, n2, color, paint, true);
    }

    public GroupBorder(Icon icon, String string, int n, int n2, Color color, Paint paint, boolean bl) {
        this.titleHeight = n;
        this.padding = n2;
        this.stroke = color;
        this.fill = paint;
        this.headerStrokeVisible = bl;
        this.label.setIcon(icon);
        this.label.setText(string);
        this.label.setHorizontalAlignment(2);
        this.label.setVerticalAlignment(0);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n, n2);
        if (this.fill != null) {
            graphics2D.setPaint(PaintUtils.buildPaint(this.fill, n3, this.titleHeight));
            graphics2D.fillRect(0, 0, n3, this.titleHeight);
        }
        if (this.stroke != null) {
            graphics2D.setColor(this.stroke);
            graphics2D.drawLine(0, this.titleHeight, 0, n4);
            graphics2D.drawLine(n3 - 1, this.titleHeight, n3 - 1, n4);
            graphics2D.drawLine(0, n4 - 1, n3, n4 - 1);
            if (this.headerStrokeVisible) {
                graphics2D.drawLine(0, 0, 0, this.titleHeight);
                graphics2D.drawLine(n3 - 1, 0, n3 - 1, this.titleHeight);
                graphics2D.drawLine(0, 0, n3, 0);
            }
        }
        this.label.setFont(component.getFont());
        this.label.setForeground(component.getForeground());
        this.label.setSize(n3 - this.padding * 2, this.titleHeight);
        graphics2D.translate(this.padding, 0);
        this.label.paint(graphics2D);
        graphics2D.dispose();
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.stroke != null) {
            return new Insets(this.titleHeight, 1, 1, 1);
        }
        return new Insets(this.titleHeight, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public int getTitleHeight() {
        return this.titleHeight;
    }

    public void setTitleHeight(int n) {
        this.titleHeight = n;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int n) {
        this.padding = n;
    }

    public Color getStroke() {
        return this.stroke;
    }

    public void setStroke(Color color) {
        this.stroke = color;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setFill(Paint paint) {
        this.fill = paint;
    }

    public Color getForeground() {
        return this.label.getForeground();
    }

    public void setForeground(Color color) {
        this.label.setForeground(color);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String string) {
        this.label.setText(string);
    }

    public boolean isHeaderStrokeVisible() {
        return this.headerStrokeVisible;
    }

    public void setHeaderStrokeVisible(boolean bl) {
        this.headerStrokeVisible = bl;
    }
}

