/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.AruiRules;
import aurelienribon.ui.css.StyleProcessor;
import aurelienribon.ui.css.StyleRuleSet;
import aurelienribon.ui.css.swing.PaintUtils;
import aurelienribon.ui.css.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class Button
extends JButton {
    public static final StyleProcessor PROCESSOR = new StyleProcessor(){

        @Override
        public void process(Object object, StyleRuleSet styleRuleSet) {
            if (object instanceof Button) {
                Button button = (Button)object;
                if (styleRuleSet.contains(AruiRules.FOREGROUND_MOUSEDOWN)) {
                    button.foregroundMouseDown = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.FOREGROUND_MOUSEDOWN), 0);
                }
                if (styleRuleSet.contains(AruiRules.FOREGROUND_MOUSEOVER)) {
                    button.foregroundMouseOver = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.FOREGROUND_MOUSEOVER), 0);
                }
                if (styleRuleSet.contains(AruiRules.STROKE)) {
                    button.stroke = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE), 0);
                }
                if (styleRuleSet.contains(AruiRules.STROKE_MOUSEDOWN)) {
                    button.strokeMouseDown = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE_MOUSEDOWN), 0);
                }
                if (styleRuleSet.contains(AruiRules.STROKE_MOUSEOVER)) {
                    button.strokeMouseOver = SwingUtils.asColor(styleRuleSet.getParams(AruiRules.STROKE_MOUSEOVER), 0);
                }
                if (styleRuleSet.contains(AruiRules.FILL)) {
                    button.fill = SwingUtils.asPaint(styleRuleSet.getParams(AruiRules.FILL), 0);
                }
                if (styleRuleSet.contains(AruiRules.FILL_MOUSEDOWN)) {
                    button.fillMouseDown = SwingUtils.asPaint(styleRuleSet.getParams(AruiRules.FILL_MOUSEDOWN), 0);
                }
                if (styleRuleSet.contains(AruiRules.FILL_MOUSEOVER)) {
                    button.fillMouseOver = SwingUtils.asPaint(styleRuleSet.getParams(AruiRules.FILL_MOUSEOVER), 0);
                }
                if (styleRuleSet.contains(AruiRules.CORNERRADIUS)) {
                    button.cornerRadius = styleRuleSet.asInteger(AruiRules.CORNERRADIUS, 0);
                }
                button.reload();
            }
        }
    };
    private Color foregroundMouseDown = Color.RED;
    private Color foregroundMouseOver = Color.RED;
    private Color stroke = Color.RED;
    private Color strokeMouseDown = Color.RED;
    private Color strokeMouseOver = Color.RED;
    private Paint fill = Color.RED;
    private Paint fillMouseDown = Color.RED;
    private Paint fillMouseOver = Color.RED;
    private int cornerRadius = 0;
    private final JLabel label = new JLabel();
    private boolean isMouseDown = false;
    private boolean isMouseOver = false;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Button.this.isMouseOver = true;
            Button.this.reload();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Button.this.isMouseOver = false;
            Button.this.reload();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Button.this.isMouseDown = true;
                Button.this.reload();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                Button.this.isMouseDown = false;
                Button.this.reload();
            }
        }
    };

    public Button() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.addMouseListener(this.mouseAdapter);
        this.reload();
    }

    private void reload() {
        this.label.setHorizontalAlignment(this.getHorizontalAlignment());
        this.label.setVerticalAlignment(this.getVerticalAlignment());
        this.label.setFont(this.getFont());
        if (this.isMouseDown && this.isMouseOver) {
            this.label.setForeground(this.foregroundMouseDown);
        } else if (this.isMouseOver || this.isMouseDown && !this.isMouseOver) {
            this.label.setForeground(this.foregroundMouseOver);
        } else {
            this.label.setForeground(this.getForeground());
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        if (this.label != null) {
            this.label.setIcon(icon);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public void setHorizontalAlignment(int n) {
        super.setHorizontalAlignment(n);
        if (this.label != null) {
            this.label.setHorizontalAlignment(n);
        }
    }

    @Override
    public void setVerticalAlignment(int n) {
        super.setVerticalAlignment(n);
        if (this.label != null) {
            this.label.setVerticalAlignment(n);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isMouseDown && this.isMouseOver) {
            graphics2D.setPaint(PaintUtils.buildPaint(this.fillMouseDown, n, n2));
            graphics2D.fillRoundRect(0, 0, n, n2, this.cornerRadius, this.cornerRadius);
            graphics2D.setColor(this.strokeMouseDown);
            graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, this.cornerRadius, this.cornerRadius);
        } else if (this.isMouseOver || this.isMouseDown && !this.isMouseOver) {
            graphics2D.setPaint(PaintUtils.buildPaint(this.fillMouseOver, n, n2));
            graphics2D.fillRoundRect(0, 0, n, n2, this.cornerRadius, this.cornerRadius);
            graphics2D.setColor(this.strokeMouseOver);
            graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, this.cornerRadius, this.cornerRadius);
        } else {
            graphics2D.setPaint(PaintUtils.buildPaint(this.fill, n, n2));
            graphics2D.fillRoundRect(0, 0, n, n2, this.cornerRadius, this.cornerRadius);
            graphics2D.setColor(this.stroke);
            graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, this.cornerRadius, this.cornerRadius);
        }
    }
}

