/*
 * griffon-crystal: Crystal icons Griffon plugin
 * Copyright 2010 and beyond, Andres Almiray
 *
 * griffon-crystal is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package griffon.plugins.crystal

import groovy.swing.factory.ImageIconFactory

/**
 * @author Andres.Almiray
 */
class CrystalIconFactory extends ImageIconFactory {
    Object newInstance(FactoryBuilderSupport builder, Object name, Object value, Map attributes) {
        String size = attributes.remove('size') ?: '16'
        String category = attributes.remove('category') ?: 'actions'
        String icon = attributes.remove('icon') ?: value 
  
        if(!icon) throw new IllegalArgumentException("In $name you must define a node value or icon:")

        size = parseSize(size)
        if(icon.endsWith('.png')) icon -= '.png'

        value = "/com/everaldo/crystal/${size}/${category}/${icon}.png"
        super.newInstance(builder, name, value, [:])
    }

    private String parseSize(String size) {
        switch(size) {
            case '16':
            case '22':
            case '24':
            case '32':
            case '48':
            case '64':
            case '128':
                return size +'x'+ size
        }
        return '16x16'
    }
}
