/*
 * Decompiled with CFR 0.152.
 */
package griffon.coverflow.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;

public class StackLayout
implements LayoutManager2 {
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    private List<Component> components = new LinkedList<Component>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (BOTTOM.equals(constraints)) {
                this.components.add(0, comp);
            } else if (TOP.equals(constraints)) {
                this.components.add(comp);
            } else {
                this.components.add(comp);
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, TOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            this.components.remove(comp);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width = 0;
            int height = 0;
            for (Component comp : this.components) {
                Dimension size = comp.getPreferredSize();
                width = Math.max(size.width, width);
                height = Math.max(size.height, height);
            }
            Insets insets = parent.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width = 0;
            int height = 0;
            for (Component comp : this.components) {
                Dimension size = comp.getMinimumSize();
                width = Math.max(size.width, width);
                height = Math.max(size.height, height);
            }
            Insets insets = parent.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width = parent.getWidth();
            int height = parent.getHeight();
            Rectangle bounds = new Rectangle(0, 0, width, height);
            int componentsCount = this.components.size();
            for (int i = 0; i < componentsCount; ++i) {
                Component comp = this.components.get(i);
                comp.setBounds(bounds);
                parent.setComponentZOrder(comp, componentsCount - i - 1);
            }
        }
    }
}

