/*
 * Decompiled with CFR 0.152.
 */
package griffon.coverflow.ui;

import griffon.coverflow.ui.CrystalCaseFactory;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageFlowItem {
    private final LazyImageLoader imageLoader;
    private final String label;

    public ImageFlowItem(Resource resource) {
        this(resource, "");
    }

    public ImageFlowItem(Resource resource, String label) {
        this(new ResourceLazyImageLoader(resource), label);
    }

    public ImageFlowItem(Image image) {
        this(image, "");
    }

    public ImageFlowItem(Image image, String label) {
        this(new ImageLazyImageLoader(image), label);
    }

    public ImageFlowItem(String fileName) {
        this(new File(fileName), "");
    }

    public ImageFlowItem(String fileName, String label) {
        this(new File(fileName), label);
    }

    public ImageFlowItem(File file) {
        this(file, "");
    }

    public ImageFlowItem(File file, String label) {
        this(new FileLazyImageLoader(file), label);
    }

    public ImageFlowItem(InputStream is) {
        this(is, "");
    }

    public ImageFlowItem(InputStream is, String label) {
        this(new InputStreamLazyImageLoader(is), label);
    }

    public ImageFlowItem(URL url) {
        this(url, "");
    }

    public ImageFlowItem(URL url, String label) {
        this(new URLLazyImageLoader(url), label);
    }

    private ImageFlowItem(LazyImageLoader imageLoader, String label) {
        this.imageLoader = imageLoader;
        this.label = label != null ? label : "";
    }

    public static List<ImageFlowItem> loadFromDirectory(File directory) {
        ArrayList<ImageFlowItem> list = new ArrayList<ImageFlowItem>();
        if (!directory.isDirectory()) {
            return list;
        }
        File[] files = directory.listFiles();
        for (int index = 0; index < files.length; ++index) {
            ImageFlowItem item = new ImageFlowItem(files[index], files[index].getName());
            list.add(item);
        }
        return list;
    }

    public Image getImage() {
        return this.imageLoader.getImage();
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return super.toString() + "[label: '" + this.label + "', image: " + this.imageLoader.toString() + "]";
    }

    private static class InputStreamLazyImageLoader
    extends LazyImageLoader {
        private final InputStream is;

        public InputStreamLazyImageLoader(InputStream is) {
            this.is = is;
        }

        @Override
        protected Image loadImage() throws IOException {
            return ImageIO.read(this.is);
        }

        public String toString() {
            return "inputStream:" + this.is;
        }
    }

    private static class FileLazyImageLoader
    extends LazyImageLoader {
        private final File file;

        public FileLazyImageLoader(File file) {
            this.file = file;
        }

        @Override
        protected Image loadImage() throws IOException {
            return ImageIO.read(this.file);
        }

        public String toString() {
            return "file: " + this.file.getAbsolutePath().toString();
        }
    }

    private static class URLLazyImageLoader
    extends LazyImageLoader {
        private final URL url;

        public URLLazyImageLoader(URL url) {
            this.url = url;
        }

        @Override
        protected Image loadImage() throws IOException {
            return ImageIO.read(this.url);
        }

        public String toString() {
            return "url: " + this.url.toString();
        }
    }

    private static class ImageLazyImageLoader
    extends LazyImageLoader {
        private final Image image;

        public ImageLazyImageLoader(Image image) {
            this.image = image;
        }

        @Override
        protected Image loadImage() throws IOException {
            return this.image;
        }

        public String toString() {
            return "image: " + this.image.toString();
        }
    }

    private static class ResourceLazyImageLoader
    extends LazyImageLoader {
        private final Resource resource;

        public ResourceLazyImageLoader(Resource resource) {
            this.resource = resource;
        }

        @Override
        protected Image loadImage() throws IOException {
            return ImageIO.read(this.resource.getResource());
        }

        public String toString() {
            return "resource: " + this.resource.toString();
        }
    }

    private static abstract class LazyImageLoader {
        private Image image;
        private final Logger log = Logger.getLogger(LazyImageLoader.class.getName());

        private LazyImageLoader() {
        }

        public Image getImage() {
            if (this.image == null) {
                try {
                    CrystalCaseFactory fx = CrystalCaseFactory.getInstance();
                    Image img = this.loadImage();
                    this.image = fx.createReflectedPicture(fx.createCrystalCase(img));
                }
                catch (IOException ioe) {
                    this.log.log(Level.INFO, "Unnable to load image for " + this, ioe);
                }
            }
            return this.image;
        }

        protected abstract Image loadImage() throws IOException;
    }

    public static class Resource {
        private final Class loadingClass;
        private final String resourceName;

        public Resource(String resourceName) {
            this(resourceName, ImageFlowItem.class);
        }

        public Resource(String resourceName, Class loadingClass) {
            this.resourceName = resourceName;
            this.loadingClass = loadingClass != null ? loadingClass : ImageFlowItem.class;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public Class getLoadingClass() {
            return this.loadingClass;
        }

        public URL getResource() {
            return this.loadingClass.getResource(this.resourceName);
        }

        public InputStream getResourceAsStream() {
            return this.loadingClass.getResourceAsStream(this.resourceName);
        }

        public String toString() {
            return "[resourceName: " + this.resourceName + ", loadingClass: " + this.loadingClass.getName() + "]";
        }
    }
}

