/*
 * Decompiled with CFR 0.152.
 */
package griffon.coverflow.ui;

import griffon.coverflow.ui.CrystalCaseFactory;
import griffon.coverflow.ui.ImageFlowItem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageFlow
extends JPanel {
    private static final double ANIM_SCROLL_DELAY = 450.0;
    private String itemText = null;
    private Timer scrollerTimer = null;
    private Timer faderTimer = null;
    private float veilAlphaLevel = 0.0f;
    private float alphaLevel = 0.0f;
    private float textAlphaLevel = 0.0f;
    private int itemIndex = -1;
    private double itemPosition = 0.0;
    private double itemSpacing = 0.4;
    private int amount = 5;
    private double sigma;
    private double rho;
    private double exp_multiplier;
    private double exp_member;
    private boolean damaged = true;
    private DrawableItem[] drawableItems;
    private FocusGrabber focusGrabber;
    private ItemScroller itemScroller;
    private MouseItemSelector mouseItemSelector;
    private CursorChanger cursorChanger;
    private MouseWheelScroller wheelScroller;
    private KeyScroller keyScroller;
    private KeyItemSelector keyItemSelector;
    private Font itemFont = new Font("Dialog", 0, 24);
    private CrystalCaseFactory fx;
    private List<ListSelectionListener> listSelectionListeners;
    private ListModel dataModel;
    private Color itemTextColor = Color.WHITE;
    private RepaintListDataListener repaintListDataListener = new RepaintListDataListener();

    public ImageFlow() {
        this(new DefaultListModel());
    }

    public ImageFlow(final ImageFlowItem[] listData) {
        this(new AbstractListModel(){

            @Override
            public int getSize() {
                return listData.length;
            }

            @Override
            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public ImageFlow(final List<?> listData) {
        this(new AbstractListModel(){

            @Override
            public int getSize() {
                return listData.size();
            }

            @Override
            public Object getElementAt(int i) {
                return listData.get(i);
            }
        });
    }

    public ImageFlow(ListModel dataModel) {
        if (dataModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        this.dataModel = dataModel;
        this.dataModel.addListDataListener(this.repaintListDataListener);
        this.fx = CrystalCaseFactory.getInstance();
        this.setLayout(new GridBagLayout());
        this.setSigma(0.5);
        this.addComponentListener(new DamageManager());
        this.initInputListeners();
        this.addInputListeners();
        this.listSelectionListeners = new ArrayList<ListSelectionListener>();
        this.setItemIndex(this.amount / 2);
        this.startFader();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageFlow.this.invalidate();
                ImageFlow.this.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ImageFlow.this.invalidate();
                ImageFlow.this.repaint();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private Dimension maximalImageSize() {
        int width = 0;
        int height = 0;
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            ImageFlowItem item = (ImageFlowItem)this.dataModel.getElementAt(i);
            width = Math.max(width, item.getImage().getWidth(null));
            height = Math.max(height, item.getImage().getHeight(null));
        }
        return new Dimension(width, height);
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListModel oldValue = this.dataModel;
        if (oldValue != null) {
            oldValue.removeListDataListener(this.repaintListDataListener);
        }
        this.dataModel = model;
        this.dataModel.addListDataListener(this.repaintListDataListener);
        this.firePropertyChange("model", oldValue, this.dataModel);
        this.adjust();
    }

    private void adjust() {
        int size = this.dataModel.getSize();
        if (this.amount > size) {
            this.setAmount(size);
            this.setItemIndex(this.amount / 2);
        }
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font itemFont) {
        Font oldValue = this.itemFont;
        if (itemFont != null && !oldValue.equals(itemFont)) {
            this.itemFont = itemFont;
            this.firePropertyChange("itemFont", oldValue, itemFont);
            this.repaint();
        }
    }

    public Color getItemTextColor() {
        return this.itemTextColor;
    }

    public void setItemTextColor(Color itemTextColor) {
        Color oldValue = this.itemTextColor;
        if (itemTextColor != null && !oldValue.equals(itemTextColor)) {
            this.itemTextColor = itemTextColor;
            this.firePropertyChange("itemTextColor", oldValue, itemTextColor);
            this.repaint();
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        if (amount > this.dataModel.getSize()) {
            throw new IllegalArgumentException("Amount cannot be greater than the current size: " + this.dataModel.getSize());
        }
        int oldValue = this.amount;
        if (this.amount != amount) {
            this.amount = amount;
            this.firePropertyChange("amount", oldValue, amount);
            this.repaint();
        }
    }

    private void setItemPosition(double itemPosition) {
        if (this.itemPosition != itemPosition) {
            this.itemPosition = itemPosition;
            this.damaged = true;
            this.repaint();
        }
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        double oldValue = this.sigma;
        if (oldValue != sigma) {
            this.sigma = sigma;
            this.rho = 1.0;
            this.computeEquationParts();
            this.rho = this.computeModifierUnprotected(0.0);
            this.computeEquationParts();
            this.damaged = true;
            this.firePropertyChange("sigma", oldValue, sigma);
            this.repaint();
        }
    }

    public double getItemSpacing() {
        return this.itemSpacing;
    }

    public void setItemSpacing(double itemSpacing) {
        if (itemSpacing < 0.0 || itemSpacing > 1.0) {
            throw new IllegalArgumentException("Spacing must be < 1.0 and > 0.0");
        }
        double oldValue = this.itemSpacing;
        if (oldValue != itemSpacing) {
            this.itemSpacing = itemSpacing;
            this.damaged = true;
            this.firePropertyChange("itemSpacing", oldValue, itemSpacing);
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension img = this.maximalImageSize();
        return new Dimension(img.width, img.height + this.itemFont.getSize() * 2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    public void next() {
        this.scrollAndAnimateBy(1);
    }

    public void previous() {
        this.scrollAndAnimateBy(-1);
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Composite oldComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.veilAlphaLevel));
        super.paintChildren(g);
        g2.setComposite(oldComposite);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        super.paintComponent(g);
        if (this.faderTimer == null) {
            return;
        }
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite oldComposite = g2.getComposite();
        if (this.damaged) {
            this.drawableItems = this.sortItemsByDepth(x, y, width, height);
            this.damaged = false;
        }
        this.drawItems(g2, this.drawableItems);
        if (this.drawableItems.length > 0) {
            this.drawItemName(g2);
        }
        g2.setComposite(oldComposite);
    }

    private ImageFlowItem getItemAt(int index) {
        return (ImageFlowItem)this.dataModel.getElementAt(index);
    }

    private void drawItems(Graphics2D g2, DrawableItem[] drawableItems) {
        for (DrawableItem item : drawableItems) {
            AlphaComposite composite = AlphaComposite.getInstance(3, (float)item.getAlpha());
            g2.setComposite(composite);
            g2.drawImage(this.getItemAt(item.getIndex()).getImage(), (int)item.getX(), (int)item.getY(), item.getWidth(), item.getHeight(), null);
        }
    }

    private DrawableItem[] sortItemsByDepth(int x, int y, int width, int height) {
        LinkedList<DrawableItem> drawables = new LinkedList<DrawableItem>();
        int size = this.dataModel.getSize();
        for (int i = 0; i < size; ++i) {
            this.promoteItemToDrawable(drawables, x, y, width, height, i - this.itemIndex);
        }
        Object[] items = new DrawableItem[drawables.size()];
        items = drawables.toArray(items);
        Arrays.sort(items);
        return items;
    }

    private void drawItemName(Graphics2D g2) {
        if (this.itemText == null || this.itemText.length() == 0) {
            return;
        }
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.textAlphaLevel));
        FontRenderContext context = g2.getFontRenderContext();
        TextLayout layout = new TextLayout(this.itemText, this.itemFont, context);
        Rectangle2D bounds = layout.getBounds();
        double bulletWidth = bounds.getWidth() + 12.0;
        double bulletHeight = bounds.getHeight() + (double)layout.getDescent() + 4.0;
        double x = ((double)this.getWidth() - bulletWidth) / 2.0;
        Dimension img = this.maximalImageSize();
        double y = (double)(this.getHeight() + img.width) / 2.0;
        BufferedImage textImage = new BufferedImage((int)bulletWidth, (int)bulletHeight, 2);
        Graphics2D g2text = textImage.createGraphics();
        g2text.setColor(new Color(0, 0, 0, 170));
        layout.draw(g2text, 6.0f, layout.getAscent() + 1.0f);
        g2text.setColor(this.itemTextColor);
        layout.draw(g2text, 6.0f, layout.getAscent());
        g2text.dispose();
        g2.drawImage((Image)this.fx.createReflectedPicture(textImage, this.fx.createGradientMask((int)bulletWidth, (int)bulletHeight)), (int)x, (int)y, null);
        g2.setComposite(composite);
    }

    private void promoteItemToDrawable(List<DrawableItem> drawables, int x, int y, int width, int height, int offset) {
        double spacing = (double)offset * this.itemSpacing;
        double position = this.itemPosition + spacing;
        if (this.itemIndex + offset < 0 || this.itemIndex + offset >= this.dataModel.getSize()) {
            return;
        }
        Image item = this.getItemAt(this.itemIndex + offset).getImage();
        Dimension img = this.maximalImageSize();
        int itemWidth = img.width;
        int itemHeight = img.height;
        double result = this.computeModifier(position);
        int newWidth = (int)((double)itemWidth * result);
        if (newWidth == 0) {
            return;
        }
        int newHeight = (int)((double)itemHeight * result);
        if (newHeight == 0) {
            return;
        }
        double item_x = (double)x + (double)(width - newWidth) / 2.0;
        double item_y = (double)y + ((double)height - (double)newHeight / 2.0) / 2.0;
        double semiWidth = (double)width / 2.0;
        if ((item_x += position * semiWidth) >= (double)width || item_x < (double)(-newWidth)) {
            return;
        }
        drawables.add(new DrawableItem(this.itemIndex + offset, item_x, item_y, newWidth, newHeight, position, result));
    }

    private void computeEquationParts() {
        this.exp_multiplier = Math.sqrt(Math.PI * 2) / this.sigma / this.rho;
        this.exp_member = 4.0 * this.sigma * this.sigma;
    }

    private double computeModifier(double x) {
        double result = this.computeModifierUnprotected(x);
        if (result > 1.0) {
            result = 1.0;
        } else if (result < -1.0) {
            result = -1.0;
        }
        return result;
    }

    private double computeModifierUnprotected(double x) {
        return this.exp_multiplier * Math.exp(-x * x / this.exp_member);
    }

    private void addInputListeners() {
        this.addMouseListener(this.focusGrabber);
        this.addMouseListener(this.itemScroller);
        this.addMouseListener(this.mouseItemSelector);
        this.addMouseMotionListener(this.cursorChanger);
        this.addMouseWheelListener(this.wheelScroller);
        this.addKeyListener(this.keyScroller);
        this.addKeyListener(this.keyItemSelector);
    }

    private void initInputListeners() {
        this.focusGrabber = new FocusGrabber();
        this.itemScroller = new ItemScroller();
        this.mouseItemSelector = new MouseItemSelector();
        this.cursorChanger = new CursorChanger();
        this.wheelScroller = new MouseWheelScroller();
        this.keyScroller = new KeyScroller();
        this.keyItemSelector = new KeyItemSelector();
    }

    private void setItemIndex(int index) {
        if (index >= 0 && index < this.dataModel.getSize()) {
            this.itemIndex = index;
            this.itemText = this.getItemAt(index).getLabel();
            this.notifyListSelectionListener();
        }
    }

    private void scrollBy(int increment) {
        this.setItemIndex(this.itemIndex + increment);
        if (this.itemIndex < 0) {
            this.setItemIndex(0);
        } else if (this.itemIndex >= this.dataModel.getSize()) {
            this.setItemIndex(this.dataModel.getSize() - 1);
        }
        this.damaged = true;
        this.repaint();
    }

    private void scrollAndAnimateBy(int increment) {
        if (this.scrollerTimer == null || !this.scrollerTimer.isRunning()) {
            int index = this.itemIndex + increment;
            if (index < 0) {
                index = 0;
            } else if (index >= this.dataModel.getSize()) {
                index = this.dataModel.getSize() - 1;
            }
            if (index == this.itemIndex) {
                return;
            }
            DrawableItem drawable = null;
            if (this.drawableItems != null) {
                for (DrawableItem item : this.drawableItems) {
                    if (item.index != index) continue;
                    drawable = item;
                    break;
                }
            }
            if (drawable != null) {
                this.scrollAndAnimate(drawable);
            }
        }
    }

    private void scrollAndAnimate(DrawableItem item) {
        this.scrollerTimer = new Timer(33, new AutoScroller(item));
        this.scrollerTimer.start();
    }

    private DrawableItem getHitItem(int x, int y) {
        for (DrawableItem item : this.drawableItems) {
            Rectangle hit = new Rectangle((int)item.getX(), (int)item.getY(), item.getWidth(), item.getHeight() / 2);
            if (!hit.contains(x, y)) continue;
            return item;
        }
        return null;
    }

    private void startFader() {
        this.faderTimer = new Timer(35, new FaderAction());
        this.faderTimer.start();
    }

    public int getMaxSelectionIndex() {
        if (this.dataModel == null) {
            return 0;
        }
        return this.dataModel.getSize();
    }

    public int getMinSelectionIndex() {
        return 0;
    }

    public int getSelectedIndex() {
        return this.itemIndex;
    }

    public Object getSelectedValue() {
        if (this.dataModel == null || this.itemIndex < 0) {
            return null;
        }
        return this.getItemAt(this.itemIndex);
    }

    public boolean isSelectedIndex(int index) {
        return this.itemIndex == index;
    }

    public void setSelectedIndex(int index) {
        this.scrollBy(index - this.itemIndex);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionListeners.remove(listener);
    }

    private void notifyListSelectionListener() {
        ListSelectionEvent event = new ListSelectionEvent(this, this.itemIndex, this.itemIndex, false);
        for (ListSelectionListener listener : this.listSelectionListeners) {
            listener.valueChanged(event);
        }
    }

    private class RepaintListDataListener
    implements ListDataListener {
        private RepaintListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ImageFlow.this.damaged = true;
            ImageFlow.this.repaint();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ImageFlow.this.damaged = true;
            ImageFlow.this.repaint();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ImageFlow.this.damaged = true;
            ImageFlow.this.repaint();
        }
    }

    private class MouseItemSelector
    extends MouseAdapter {
        private MouseItemSelector() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DrawableItem item;
            if (ImageFlow.this.scrollerTimer != null && ImageFlow.this.scrollerTimer.isRunning() || ImageFlow.this.drawableItems == null || e.getButton() != 1 || (item = ImageFlow.this.getHitItem(e.getX(), e.getY())) == null || item.getIndex() == ImageFlow.this.itemIndex) {
                // empty if block
            }
        }
    }

    private class KeyItemSelector
    extends KeyAdapter {
        private KeyItemSelector() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (ImageFlow.this.scrollerTimer != null && ImageFlow.this.scrollerTimer.isRunning() || ImageFlow.this.drawableItems == null || e.getKeyCode() == 10) {
                // empty if block
            }
        }
    }

    private class CursorChanger
    extends MouseMotionAdapter {
        private CursorChanger() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ImageFlow.this.scrollerTimer != null && ImageFlow.this.scrollerTimer.isRunning() || ImageFlow.this.drawableItems == null) {
                return;
            }
            DrawableItem item = ImageFlow.this.getHitItem(e.getX(), e.getY());
            if (item != null) {
                ImageFlow.this.getParent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ImageFlow.this.getParent().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class AutoScroller
    implements ActionListener {
        private double position;
        private int index;
        private long start;

        private AutoScroller(DrawableItem item) {
            this.index = item.getIndex();
            this.position = item.getPosition();
            this.start = System.currentTimeMillis();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ImageFlow.this.isShowing()) {
                return;
            }
            long elapsed = System.currentTimeMillis() - this.start;
            if ((double)elapsed < 225.0) {
                ImageFlow.this.textAlphaLevel = (float)(1.0 - 2.0 * ((double)elapsed / 450.0));
            } else {
                ImageFlow.this.itemText = ImageFlow.this.getItemAt(this.index).getLabel();
                ImageFlow.this.textAlphaLevel = (float)(((double)elapsed / 450.0 - 0.5) * 2.0);
                if (ImageFlow.this.textAlphaLevel > 1.0f) {
                    ImageFlow.this.textAlphaLevel = 1.0f;
                }
            }
            if (ImageFlow.this.textAlphaLevel < 0.1f) {
                ImageFlow.this.textAlphaLevel = 0.1f;
            }
            double newPosition = (double)elapsed / 450.0 * -this.position;
            if ((double)elapsed >= 450.0) {
                ((Timer)e.getSource()).stop();
                ImageFlow.this.setItemIndex(this.index);
                ImageFlow.this.setItemPosition(0.0);
                return;
            }
            ImageFlow.this.setItemPosition(newPosition);
        }
    }

    private class DamageManager
    extends ComponentAdapter {
        private DamageManager() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ImageFlow.this.damaged = true;
        }
    }

    private class ItemScroller
    extends MouseAdapter {
        private ItemScroller() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DrawableItem item;
            if (ImageFlow.this.scrollerTimer != null && ImageFlow.this.scrollerTimer.isRunning() || ImageFlow.this.drawableItems == null) {
                return;
            }
            if (e.getButton() == 1 && (item = ImageFlow.this.getHitItem(e.getX(), e.getY())) != null && item.getIndex() != ImageFlow.this.itemIndex) {
                ImageFlow.this.scrollAndAnimate(item);
            }
        }
    }

    private class FocusGrabber
    extends MouseAdapter {
        private FocusGrabber() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImageFlow.this.requestFocus();
        }
    }

    private class KeyScroller
    extends KeyAdapter {
        private KeyScroller() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 37: 
                case 38: {
                    ImageFlow.this.scrollAndAnimateBy(-1);
                    break;
                }
                case 39: 
                case 40: {
                    ImageFlow.this.scrollAndAnimateBy(1);
                    break;
                }
                case 35: {
                    ImageFlow.this.scrollBy(ImageFlow.this.dataModel.getSize() - ImageFlow.this.itemIndex - 1);
                    break;
                }
                case 36: {
                    ImageFlow.this.scrollBy(-ImageFlow.this.itemIndex - 1);
                    break;
                }
                case 33: {
                    ImageFlow.this.scrollAndAnimateBy(-ImageFlow.this.amount / 2);
                    break;
                }
                case 34: {
                    ImageFlow.this.scrollAndAnimateBy(ImageFlow.this.amount / 2);
                }
            }
        }
    }

    private class MouseWheelScroller
    implements MouseWheelListener {
        private MouseWheelScroller() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int increment = e.getWheelRotation();
            ImageFlow.this.scrollAndAnimateBy(increment);
        }
    }

    private class DrawableItem
    implements Comparable {
        private int index;
        private double x;
        private double y;
        private int width;
        private int height;
        private double zOrder;
        private double position;

        private DrawableItem(int index, double x, double y, int width, int height, double position, double zOrder) {
            this.index = index;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.position = position;
            this.zOrder = zOrder;
        }

        public int compareTo(Object o) {
            double zOrder2 = ((DrawableItem)o).zOrder;
            if (this.zOrder < zOrder2) {
                return -1;
            }
            if (this.zOrder > zOrder2) {
                return 1;
            }
            return 0;
        }

        public double getPosition() {
            return this.position;
        }

        public double getAlpha() {
            return this.zOrder * (double)ImageFlow.this.alphaLevel;
        }

        public int getHeight() {
            return this.height;
        }

        public int getIndex() {
            return this.index;
        }

        public int getWidth() {
            return this.width;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public String toString() {
            return super.toString() + "[index: " + this.index + ", item: " + ImageFlow.this.getItemAt(this.index).toString() + "]";
        }
    }

    private class FaderAction
    implements ActionListener {
        private long start = 0L;

        private FaderAction() {
            ImageFlow.this.alphaLevel = 0.0f;
            ImageFlow.this.textAlphaLevel = 0.0f;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ImageFlow.this.isShowing()) {
                return;
            }
            if (this.start == 0L) {
                this.start = System.currentTimeMillis();
            }
            ImageFlow.this.alphaLevel = (float)(System.currentTimeMillis() - this.start) / 500.0f;
            ImageFlow.this.textAlphaLevel = ImageFlow.this.alphaLevel;
            if (ImageFlow.this.alphaLevel > 1.0f) {
                ImageFlow.this.alphaLevel = 1.0f;
                ImageFlow.this.textAlphaLevel = 1.0f;
                ImageFlow.this.faderTimer.stop();
            }
            ImageFlow.this.repaint();
        }
    }
}

