/*
 * Decompiled with CFR 0.152.
 */
package griffon.coverflow.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class CrystalCaseFactory {
    private static CrystalCaseFactory instance = null;

    public static CrystalCaseFactory getInstance() {
        if (instance == null) {
            instance = new CrystalCaseFactory();
        }
        return instance;
    }

    public BufferedImage createCrystalCase(Image cover) {
        int imageWidth = cover.getWidth(null);
        int imageHeight = cover.getHeight(null);
        BufferedImage crystal = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D g2 = crystal.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int width = cover.getWidth(null);
        int height = cover.getHeight(null);
        float scale = width > height ? (float)imageWidth / (float)width : (float)imageHeight / (float)height;
        int scaledWidth = (int)((float)width * scale);
        int scaledHeight = (int)((float)height * scale);
        int x = (imageWidth - scaledWidth) / 2;
        int y = (imageHeight - scaledHeight) / 2;
        g2.drawImage(cover, x, y, scaledWidth, scaledHeight, null);
        g2.dispose();
        return crystal;
    }

    public BufferedImage createReflectedPicture(BufferedImage item) {
        return this.createReflectedPicture(item, this.createGradientMask(item.getWidth(), item.getHeight()));
    }

    public BufferedImage createReflectedPicture(BufferedImage item, BufferedImage alphaMask) {
        int itemWidth = item.getWidth();
        int itemHeight = item.getHeight();
        BufferedImage buffer = this.createReflection(item, itemWidth, itemHeight);
        this.applyAlphaMask(buffer, alphaMask, itemWidth, itemHeight);
        return buffer;
    }

    private void applyAlphaMask(BufferedImage buffer, BufferedImage alphaMask, int itemWidth, int itemHeight) {
        Graphics2D g2 = buffer.createGraphics();
        g2.setComposite(AlphaComposite.DstOut);
        g2.drawImage(alphaMask, null, 0, itemHeight);
        g2.dispose();
    }

    private BufferedImage createReflection(BufferedImage item, int itemWidth, int itemHeight) {
        BufferedImage buffer = new BufferedImage(itemWidth, itemHeight << 1, 2);
        Graphics2D g = buffer.createGraphics();
        g.drawImage(item, null, null);
        g.translate(0, itemHeight << 1);
        AffineTransform reflectTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        g.drawImage(item, reflectTransform, null);
        g.translate(0, -(itemHeight << 1));
        g.dispose();
        return buffer;
    }

    public BufferedImage createGradientMask(int itemWidth, int itemHeight) {
        BufferedImage gradient = new BufferedImage(itemWidth, itemHeight, 2);
        Graphics2D g = gradient.createGraphics();
        GradientPaint painter = new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.5f), 0.0f, (float)itemHeight / 2.0f, new Color(1.0f, 1.0f, 1.0f, 1.0f));
        g.setPaint(painter);
        g.fill(new Rectangle2D.Double(0.0, 0.0, itemWidth, itemHeight));
        g.dispose();
        return gradient;
    }
}

