/*
 * Decompiled with CFR 0.152.
 */
package griffon.coverflow.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private static final String GRADIENT_START = "gradientStart";
    private static final String GRADIENT_END = "gradientEnd";
    private BufferedImage gradientImage;
    private Color gradientStart = new Color(110, 110, 110);
    private Color gradientEnd = new Color(0, 0, 0);

    public GradientPanel() {
        this(new BorderLayout());
    }

    public GradientPanel(LayoutManager layout) {
        super(layout);
        this.addComponentListener(new GradientCacheManager());
    }

    public Color getGradientStart() {
        return this.gradientStart;
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public void setGradientStart(Color gradientStart) {
        if (!this.gradientStart.equals(gradientStart)) {
            Color oldValue = this.gradientStart;
            this.gradientStart = gradientStart;
            this.disposeImageCache();
            this.firePropertyChange(GRADIENT_START, oldValue, gradientStart);
        }
    }

    public void setGradientEnd(Color gradientEnd) {
        if (!this.gradientEnd.equals(gradientEnd)) {
            Color oldValue = this.gradientEnd;
            this.gradientEnd = gradientEnd;
            this.disposeImageCache();
            this.firePropertyChange(GRADIENT_END, oldValue, gradientEnd);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.createImageCache();
        if (this.gradientImage != null) {
            Shape clip = g.getClip();
            Rectangle bounds = clip.getBounds();
            BufferedImage backgroundImage = this.gradientImage.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
            g.drawImage(backgroundImage, bounds.x, bounds.y, null);
        }
    }

    private void createImageCache() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        if (this.gradientImage == null || width != this.gradientImage.getWidth() || height != this.gradientImage.getHeight()) {
            this.gradientImage = new BufferedImage(width, height, 1);
            Graphics2D g2 = this.gradientImage.createGraphics();
            GradientPaint painter = new GradientPaint(0.0f, 0.0f, this.gradientEnd, 0.0f, height / 2, this.gradientStart);
            g2.setPaint(painter);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, (double)height / 2.0);
            g2.fill(rect);
            painter = new GradientPaint(0.0f, height / 2, this.gradientStart, 0.0f, height, this.gradientEnd);
            g2.setPaint(painter);
            rect = new Rectangle2D.Double(0.0, (double)height / 2.0 - 1.0, width, height);
            g2.fill(rect);
            g2.dispose();
        }
    }

    private synchronized void disposeImageCache() {
        if (this.gradientImage != null) {
            this.gradientImage.flush();
            this.gradientImage = null;
        }
    }

    private class GradientCacheManager
    implements ComponentListener {
        private GradientCacheManager() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            GradientPanel.this.disposeImageCache();
        }
    }
}

