/*
 * Copyright 2010-2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package griffon.plugins.countries

/**
 * @author Andres Almiray
 */
class Country {
    public static final Country AD = new Country('AD')
    public static final Country AE = new Country('AE')
    public static final Country AF = new Country('AF')
    public static final Country AG = new Country('AG')
    public static final Country AI = new Country('AI')
    public static final Country AL = new Country('AL')
    public static final Country AM = new Country('AM')
    public static final Country AN = new Country('AN')
    public static final Country AO = new Country('AO')
    public static final Country AQ = new Country('AQ')
    public static final Country AR = new Country('AR')
    public static final Country AS = new Country('AS')
    public static final Country AT = new Country('AT')
    public static final Country AU = new Country('AU')
    public static final Country AW = new Country('AW')
    public static final Country AX = new Country('AX')
    public static final Country AZ = new Country('AZ')
    public static final Country BA = new Country('BA')
    public static final Country BB = new Country('BB')
    public static final Country BD = new Country('BD')
    public static final Country BE = new Country('BE')
    public static final Country BF = new Country('BF')
    public static final Country BG = new Country('BG')
    public static final Country BH = new Country('BH')
    public static final Country BI = new Country('BI')
    public static final Country BJ = new Country('BJ')
    public static final Country BL = new Country('BL')
    public static final Country BM = new Country('BM')
    public static final Country BN = new Country('BN')
    public static final Country BO = new Country('BO')
    public static final Country BR = new Country('BR')
    public static final Country BS = new Country('BS')
    public static final Country BT = new Country('BT')
    public static final Country BV = new Country('BV')
    public static final Country BW = new Country('BW')
    public static final Country BY = new Country('BY')
    public static final Country BZ = new Country('BZ')
    public static final Country CA = new Country('CA')
    public static final Country CC = new Country('CC')
    public static final Country CD = new Country('CD')
    public static final Country CF = new Country('CF')
    public static final Country CG = new Country('CG')
    public static final Country CH = new Country('CH')
    public static final Country CI = new Country('CI')
    public static final Country CK = new Country('CK')
    public static final Country CL = new Country('CL')
    public static final Country CM = new Country('CM')
    public static final Country CN = new Country('CN')
    public static final Country CO = new Country('CO')
    public static final Country CR = new Country('CR')
    public static final Country CT = new Country('CT')
    public static final Country CU = new Country('CU')
    public static final Country CV = new Country('CV')
    public static final Country CX = new Country('CX')
    public static final Country CY = new Country('CY')
    public static final Country CZ = new Country('CZ')
    public static final Country DE = new Country('DE')
    public static final Country DJ = new Country('DJ')
    public static final Country DK = new Country('DK')
    public static final Country DM = new Country('DM')
    public static final Country DO = new Country('DO')
    public static final Country DZ = new Country('DZ')
    public static final Country EC = new Country('EC')
    public static final Country EE = new Country('EE')
    public static final Country EG = new Country('EG')
    public static final Country EH = new Country('EH')
    public static final Country EN = new Country('EN')
    public static final Country ER = new Country('ER')
    public static final Country ES = new Country('ES')
    public static final Country ET = new Country('ET')
    public static final Country EU = new Country('EU')
    public static final Country FI = new Country('FI')
    public static final Country FJ = new Country('FJ')
    public static final Country FK = new Country('FK')
    public static final Country FM = new Country('FM')
    public static final Country FO = new Country('FO')
    public static final Country FR = new Country('FR')
    public static final Country GA = new Country('GA')
    public static final Country GB = new Country('GB')
    public static final Country GD = new Country('GD')
    public static final Country GE = new Country('GE')
    public static final Country GF = new Country('GF')
    public static final Country GG = new Country('GG')
    public static final Country GH = new Country('GH')
    public static final Country GI = new Country('GI')
    public static final Country GL = new Country('GL')
    public static final Country GM = new Country('GM')
    public static final Country GN = new Country('GN')
    public static final Country GP = new Country('GP')
    public static final Country GQ = new Country('GQ')
    public static final Country GR = new Country('GR')
    public static final Country GS = new Country('GS')
    public static final Country GT = new Country('GT')
    public static final Country GU = new Country('GU')
    public static final Country GW = new Country('GW')
    public static final Country GY = new Country('GY')
    public static final Country HK = new Country('HK')
    public static final Country HM = new Country('HM')
    public static final Country HN = new Country('HN')
    public static final Country HR = new Country('HR')
    public static final Country HT = new Country('HT')
    public static final Country HU = new Country('HU')
    public static final Country ID = new Country('ID')
    public static final Country IE = new Country('IE')
    public static final Country IL = new Country('IL')
    public static final Country IM = new Country('IM')
    public static final Country IN = new Country('IN')
    public static final Country IO = new Country('IO')
    public static final Country IQ = new Country('IQ')
    public static final Country IR = new Country('IR')
    public static final Country IS = new Country('IS')
    public static final Country IT = new Country('IT')
    public static final Country JE = new Country('JE')
    public static final Country JM = new Country('JM')
    public static final Country JO = new Country('JO')
    public static final Country JP = new Country('JP')
    public static final Country KE = new Country('KE')
    public static final Country KG = new Country('KG')
    public static final Country KH = new Country('KH')
    public static final Country KI = new Country('KI')
    public static final Country KM = new Country('KM')
    public static final Country KN = new Country('KN')
    public static final Country KP = new Country('KP')
    public static final Country KR = new Country('KR')
    public static final Country KW = new Country('KW')
    public static final Country KY = new Country('KY')
    public static final Country KZ = new Country('KZ')
    public static final Country LA = new Country('LA')
    public static final Country LB = new Country('LB')
    public static final Country LC = new Country('LC')
    public static final Country LI = new Country('LI')
    public static final Country LK = new Country('LK')
    public static final Country LR = new Country('LR')
    public static final Country LS = new Country('LS')
    public static final Country LT = new Country('LT')
    public static final Country LU = new Country('LU')
    public static final Country LV = new Country('LV')
    public static final Country LY = new Country('LY')
    public static final Country MA = new Country('MA')
    public static final Country MC = new Country('MC')
    public static final Country MD = new Country('MD')
    public static final Country ME = new Country('ME')
    public static final Country MF = new Country('MF')
    public static final Country MG = new Country('MG')
    public static final Country MH = new Country('MH')
    public static final Country MK = new Country('MK')
    public static final Country ML = new Country('ML')
    public static final Country MM = new Country('MM')
    public static final Country MN = new Country('MN')
    public static final Country MO = new Country('MO')
    public static final Country MP = new Country('MP')
    public static final Country MQ = new Country('MQ')
    public static final Country MR = new Country('MR')
    public static final Country MS = new Country('MS')
    public static final Country MT = new Country('MT')
    public static final Country MU = new Country('MU')
    public static final Country MV = new Country('MV')
    public static final Country MW = new Country('MW')
    public static final Country MX = new Country('MX')
    public static final Country MY = new Country('MY')
    public static final Country MZ = new Country('MZ')
    public static final Country NA = new Country('NA')
    public static final Country NC = new Country('NC')
    public static final Country NE = new Country('NE')
    public static final Country NF = new Country('NF')
    public static final Country NG = new Country('NG')
    public static final Country NI = new Country('NI')
    public static final Country NL = new Country('NL')
    public static final Country NO = new Country('NO')
    public static final Country NP = new Country('NP')
    public static final Country NR = new Country('NR')
    public static final Country NU = new Country('NU')
    public static final Country NZ = new Country('NZ')
    public static final Country OM = new Country('OM')
    public static final Country PA = new Country('PA')
    public static final Country PE = new Country('PE')
    public static final Country PF = new Country('PF')
    public static final Country PG = new Country('PG')
    public static final Country PH = new Country('PH')
    public static final Country PK = new Country('PK')
    public static final Country PL = new Country('PL')
    public static final Country PM = new Country('PM')
    public static final Country PN = new Country('PN')
    public static final Country PR = new Country('PR')
    public static final Country PS = new Country('PS')
    public static final Country PT = new Country('PT')
    public static final Country PW = new Country('PW')
    public static final Country PY = new Country('PY')
    public static final Country QA = new Country('QA')
    public static final Country RE = new Country('RE')
    public static final Country RO = new Country('RO')
    public static final Country RS = new Country('RS')
    public static final Country RU = new Country('RU')
    public static final Country RW = new Country('RW')
    public static final Country SA = new Country('SA')
    public static final Country SB = new Country('SB')
    public static final Country SC = new Country('SC')
    public static final Country SD = new Country('SD')
    public static final Country SE = new Country('SE')
    public static final Country SG = new Country('SG')
    public static final Country SH = new Country('SH')
    public static final Country SI = new Country('SI')
    public static final Country SJ = new Country('SJ')
    public static final Country SK = new Country('SK')
    public static final Country SL = new Country('SL')
    public static final Country SM = new Country('SM')
    public static final Country SN = new Country('SN')
    public static final Country SO = new Country('SO')
    public static final Country SR = new Country('SR')
    public static final Country SS = new Country('SS')
    public static final Country ST = new Country('ST')
    public static final Country SV = new Country('SV')
    public static final Country SY = new Country('SY')
    public static final Country SZ = new Country('SZ')
    public static final Country TC = new Country('TC')
    public static final Country TD = new Country('TD')
    public static final Country TF = new Country('TF')
    public static final Country TG = new Country('TG')
    public static final Country TH = new Country('TH')
    public static final Country TJ = new Country('TJ')
    public static final Country TK = new Country('TK')
    public static final Country TL = new Country('TL')
    public static final Country TM = new Country('TM')
    public static final Country TN = new Country('TN')
    public static final Country TO = new Country('TO')
    public static final Country TR = new Country('TR')
    public static final Country TT = new Country('TT')
    public static final Country TV = new Country('TV')
    public static final Country TW = new Country('TW')
    public static final Country TZ = new Country('TZ')
    public static final Country UA = new Country('UA')
    public static final Country UG = new Country('UG')
    public static final Country UM = new Country('UM')
    public static final Country US = new Country('US')
    public static final Country UY = new Country('UY')
    public static final Country UZ = new Country('UZ')
    public static final Country VA = new Country('VA')
    public static final Country VC = new Country('VC')
    public static final Country VE = new Country('VE')
    public static final Country VG = new Country('VG')
    public static final Country VI = new Country('VI')
    public static final Country VN = new Country('VN')
    public static final Country VU = new Country('VU')
    public static final Country WF = new Country('WF')
    public static final Country WL = new Country('WL')
    public static final Country WS = new Country('WS')
    public static final Country XL = new Country('XL')
    public static final Country YE = new Country('YE')
    public static final Country YT = new Country('YT')
    public static final Country ZA = new Country('ZA')
    public static final Country ZM = new Country('ZM')
    public static final Country ZW = new Country('ZW')

    public static final Country[] COUNTRIES = [
        AD, AE, AF, AG, AI, AL, AM, AN, AO, AQ,
        AR, AS, AT, AU, AW, AX, AZ, BA, BB, BD,
        BE, BF, BG, BH, BI, BJ, BL, BM, BN, BO,
        BR, BS, BT, BV, BW, BY, BZ, CA, CC, CD,
        CF, CG, CH, CI, CK, CL, CM, CN, CO, CR,
        CT, CU, CV, CX, CY, CZ, DE, DJ, DK, DM,
        DO, DZ, EC, EE, EG, EH, EN, ER, ES, ET,
        EU, FI, FJ, FK, FM, FO, FR, GA, GB, GD,
        GE, GF, GG, GH, GI, GL, GM, GN, GP, GQ,
        GR, GS, GT, GU, GW, GY, HK, HM, HN, HR,
        HT, HU, ID, IE, IL, IM, IN, IO, IQ, IR,
        IS, IT, JE, JM, JO, JP, KE, KG, KH, KI,
        KM, KN, KP, KR, KW, KY, KZ, LA, LB, LC,
        LI, LK, LR, LS, LT, LU, LV, LY, MA, MC,
        MD, ME, MF, MG, MH, MK, ML, MM, MN, MO,
        MP, MQ, MR, MS, MT, MU, MV, MW, MX, MY,
        MZ, NA, NC, NE, NF, NG, NI, NL, NO, NP,
        NR, NU, NZ, OM, PA, PE, PF, PG, PH, PK,
        PL, PM, PN, PR, PS, PT, PW, PY, QA, RE,
        RO, RS, RU, RW, SA, SB, SC, SD, SE, SG,
        SH, SI, SJ, SK, SL, SM, SN, SO, SR, SS,
        ST, SV, SY, SZ, TC, TD, TF, TG, TH, TJ,
        TK, TL, TM, TN, TO, TR, TT, TV, TW, TZ,
        UA, UG, UM, US, UY, UZ, VA, VC, VE, VG,
        VI, VN, VU, WF, WL, WS, XL, YE, YT, ZA,
        ZM, ZW
    ]

    final String code
    final String name

    private static ResourceBundle COUNTRY_NAMES

    Country(String code) {
        this.code = code
        this.name = getBundle().getString(code.toLowerCase())
    }

    private static ResourceBundle getBundle() {
        synchronized(Country) {
            if(!COUNTRY_NAMES) {
                COUNTRY_NAMES = ResourceBundle.getBundle('griffon.plugins.countries.countrynames',
                                    Locale.default, Thread.currentThread().contextClassLoader)
            }
            return COUNTRY_NAMES
        }
    }

    String toString() {
        "$name [$code]"
    }

    boolean equals(Object o) {
        if(o == null) return false
        if(o == this) return true
        if(!(o instanceof Country)) return false
        code == o.code && name == o.name
    }

    int hashCode() {
        (code.hashCode()*37) + (name.hashCode()*31)
    }

    int compareTo(Object o) {
        if (!(o instanceof Country)) {
            throw new ClassCastException("Expected type was ${Country} but got ${o?.getClass()}")
        }
        code <=> o.code
    }

    static Country resolveByCode(String code) {
        if(!code || code.size() != 2) {
            throw new IllegalArgumentException("Code '${code}' is not a valid ISO 3166-1 alpha-2 code")
        }

        Country country = COUNTRIES.find { it.code == code.toUpperCase() }
        if(!country) {
            throw new IllegalArgumentException("Code '${code}' is not a valid ISO 3166-1 alpha-2 code")
        }

        country
    }
}
