/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.couchdb.json;

import java.sql.Timestamp;
import java.util.Date;
import net.sf.ezmorph.MorphUtils;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.object.DateMorpher;
import org.apache.commons.lang.time.DateFormatUtils;

public class JsonConverterUtils {
    public static final String DATE_PATTERN = "yyyy/MM/dd HH:mm:ss Z";
    private static final MorpherRegistry morpher = new MorpherRegistry();
    private static final DateMorpher dm = new DateMorpher(new String[]{"yyyy/MM/dd HH:mm:ss Z", "yyyy/MM/dd HH:mm:ss.S Z", "yyyy/MM/dd HH:mm:ssZ", "yyyy/MM/dd HH:mm:ss.SZ", "yyyy/MM/dd HH:mm:ss.S z", "yyyy/MM/dd HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ssZ", "EEE, dd MMM yyyy HH:mm:ss Z", "EEE, dd MMM yyyy HH:mm:ss z"}, true);

    public static Object fromJSON(Class target, Object value) {
        return morpher.morph(target, value);
    }

    public static Object toJSON(Object in) {
        Object value = in;
        if (value instanceof java.sql.Date || value instanceof Timestamp) {
            value = new Date(((Date)value).getTime());
        }
        if (value instanceof Date) {
            value = DateFormatUtils.formatUTC((Date)((Date)value), (String)DATE_PATTERN);
        }
        return value;
    }

    private JsonConverterUtils() {
    }

    static {
        MorphUtils.registerStandardMorphers((MorpherRegistry)morpher);
        morpher.registerMorpher((Morpher)dm);
    }
}

