/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.couchdb;

import griffon.plugins.couchdb.CouchdbProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.jcouchdb.db.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCouchdbProvider
implements CouchdbProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCouchdbProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withCouchdb(Closure<R> closure) {
        return this.withCouchdb(DEFAULT, closure);
    }

    @Override
    public <R> R withCouchdb(String databaseName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (closure != null) {
            Database database = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on databaseName '" + databaseName + "'");
            }
            return (R)closure.call(new Object[]{databaseName, database});
        }
        return null;
    }

    @Override
    public <R> R withCouchdb(CallableWithArgs<R> callable) {
        return this.withCouchdb(DEFAULT, callable);
    }

    @Override
    public <R> R withCouchdb(String databaseName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (callable != null) {
            Database database = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on databaseName '" + databaseName + "'");
            }
            callable.setArgs(new Object[]{databaseName, database});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract Database getDatabase(String var1);
}

