/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.couchdb.CouchdbAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.CouchdbAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleCouchdbAware
extends EclipseAnnotationHandler<CouchdbAware> {
    private final EclipseCouchdbAwareHandler handler = new EclipseCouchdbAwareHandler();

    public void handle(AnnotationValues<CouchdbAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(CouchdbAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.couchdb.CouchdbContributionHandler", (Annotation)source);
        this.handler.addCouchdbProviderField(type);
        this.handler.addCouchdbProviderAccessors(type);
        this.handler.addCouchdbContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseCouchdbAwareHandler
    extends CouchdbAwareHandler<EclipseType> {
        private EclipseCouchdbAwareHandler() {
        }
    }
}

