/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.cmis.CmisAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.CmisAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleCmisAware
extends EclipseAnnotationHandler<CmisAware> {
    private final EclipseCmisAwareHandler handler = new EclipseCmisAwareHandler();

    public void handle(AnnotationValues<CmisAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(CmisAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.cmis.CmisContributionHandler", (Annotation)source);
        this.handler.addCmisProviderField(type);
        this.handler.addCmisProviderAccessors(type);
        this.handler.addCmisContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseCmisAwareHandler
    extends CmisAwareHandler<EclipseType> {
        private EclipseCmisAwareHandler() {
        }
    }
}

