/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.cmis;

import griffon.plugins.cmis.CmisProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.apache.chemistry.opencmis.client.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmisProvider
implements CmisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCmisProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withCmis(Closure<R> closure) {
        return this.withCmis(DEFAULT, closure);
    }

    @Override
    public <R> R withCmis(String sessionName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)sessionName)) {
            sessionName = DEFAULT;
        }
        if (closure != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on session '" + sessionName + "'");
            }
            return (R)closure.call(new Object[]{sessionName, this.getSession(sessionName)});
        }
        return null;
    }

    @Override
    public <R> R withCmis(CallableWithArgs<R> callable) {
        return this.withCmis(DEFAULT, callable);
    }

    @Override
    public <R> R withCmis(String sessionName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)sessionName)) {
            sessionName = DEFAULT;
        }
        if (callable != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on session '" + sessionName + "'");
            }
            callable.setArgs(new Object[]{sessionName, this.getSession(sessionName)});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract Session getSession(String var1);
}

