/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.plot;

import com.thecoderscorner.groovychart.chart.BeanBuilder;
import com.thecoderscorner.groovychart.chart.Buildable;
import com.thecoderscorner.groovychart.chart.ChartBuilder;
import com.thecoderscorner.groovychart.plot.Plotable;
import com.thecoderscorner.groovychart.util.AutoBeanPropertySetter;
import java.beans.IntrospectionException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.Layer;

public class XYPlotBuilder
extends BeanBuilder
implements Buildable,
Plotable {
    private static final Logger logger = Logger.getLogger(XYPlotBuilder.class.getPackage().getName());
    private XYPlot plot;
    private Object parent;
    private String name;

    public XYPlotBuilder() {
        try {
            this.setBeanClass(XYPlot.class);
        }
        catch (IntrospectionException introspectionException) {
            logger.log(Level.WARNING, introspectionException.getMessage(), introspectionException);
        }
    }

    @Override
    public void setChartBuilder(ChartBuilder chartBuilder) {
        this.plot = (XYPlot)chartBuilder.getUnderlyingChart().getChart().getPlot();
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        String string = object.toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("processNode method: " + string + " map: " + map + " value: " + object2);
        }
        if (object2 != null && object2 instanceof XYPlot) {
            this.plot = (XYPlot)object2;
        } else if (string.equalsIgnoreCase("xyplot")) {
            this.setProperties(this.plot, map);
        } else if (string.equalsIgnoreCase("rangeMarker") || string.equalsIgnoreCase("domainMarker")) {
            boolean bl = string.equalsIgnoreCase("rangeMarker");
            if (object2 != null) {
                if (object2 instanceof Map) {
                    for (Layer layer : map.keySet()) {
                        Marker marker = (Marker)map.get(layer);
                        if (bl) {
                            this.plot.addRangeMarker(marker, layer);
                            continue;
                        }
                        this.plot.addDomainMarker(marker, layer);
                    }
                } else if (object2 instanceof Marker) {
                    Marker marker = (Marker)object2;
                    if (bl) {
                        this.plot.addRangeMarker(marker);
                    } else {
                        this.plot.addDomainMarker(marker);
                    }
                }
            } else if (map.containsKey("marker")) {
                Marker marker = (Marker)map.get("marker");
                if (map.containsKey("layer")) {
                    Layer layer = (Layer)map.get("layer");
                    if (bl) {
                        this.plot.addRangeMarker(marker, layer);
                    } else {
                        this.plot.addDomainMarker(marker, layer);
                    }
                } else if (bl) {
                    this.plot.addRangeMarker(marker);
                } else {
                    this.plot.addDomainMarker(marker);
                }
            } else {
                for (Layer layer : map.keySet()) {
                    Marker marker = (Marker)map.get(layer);
                    if (bl) {
                        this.plot.addRangeMarker(marker, layer);
                        continue;
                    }
                    this.plot.addDomainMarker(marker, layer);
                }
            }
        } else {
            AutoBeanPropertySetter.autoSetProp(this.plot, string, object2);
        }
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public void nodeCompleted(Object object) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Plot getPlot() {
        return this.plot;
    }

    public XYPlot getXYPlot() {
        return this.plot;
    }
}

