/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.dataset.series.xyz;

import com.thecoderscorner.groovychart.dataset.BaseDatasetBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYZDataset;

public class DefaultXYZDatasetBuilder
extends BaseDatasetBuilder {
    private static final Logger logger = Logger.getLogger(DefaultXYZDatasetBuilder.class.getPackage().getName());
    private String seriesTitle;
    private double[] x;
    private double[] y;
    private double[] z;
    private DefaultXYZDataset xyzDataset = new DefaultXYZDataset();

    @Override
    public Dataset getDataset() {
        return this.getXyzDataset();
    }

    public DefaultXYZDataset getXyzDataset() {
        return this.xyzDataset;
    }

    public void setXyzDataset(DefaultXYZDataset defaultXYZDataset) {
        this.xyzDataset = defaultXYZDataset;
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DefaultXYZDatasetBuilder: " + object + ", " + map + ", " + object2);
            if (object2 != null) {
                logger.fine("Value object = " + object2.getClass());
            }
        }
        String string = object.toString();
        if (object2 != null && object2 instanceof DefaultXYZDataset) {
            this.xyzDataset = (DefaultXYZDataset)object2;
        } else if (string.equalsIgnoreCase("series")) {
            if (object2 == null) {
                object2 = map.get("value");
            }
            this.seriesTitle = object2.toString();
        } else if (string.equalsIgnoreCase("X")) {
            List list = (List)object2;
            this.x = new double[list.size()];
            Iterator iterator = ((List)object2).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.x[n] = (Double)iterator.next();
                ++n;
            }
            if (this.seriesTitle != null && this.y != null && this.z != null) {
                this.addSeries();
            }
        } else if (string.equalsIgnoreCase("Y")) {
            List list = (List)object2;
            this.y = new double[list.size()];
            Iterator iterator = ((List)object2).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.y[n] = (Double)iterator.next();
                ++n;
            }
            if (this.seriesTitle != null && this.x != null && this.z != null) {
                this.addSeries();
            }
        } else if (string.equalsIgnoreCase("Z")) {
            List list = (List)object2;
            this.z = new double[list.size()];
            Iterator iterator = ((List)object2).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.z[n] = (Double)iterator.next();
                ++n;
            }
            if (this.seriesTitle != null && this.x != null && this.y != null) {
                this.addSeries();
            }
        }
    }

    private void addSeries() {
        double[][] dArrayArray = new double[][]{this.x, this.y, this.z};
        this.xyzDataset.addSeries((Comparable)((Object)this.seriesTitle), (double[][])dArrayArray);
        this.seriesTitle = null;
        this.z = null;
        this.y = null;
        this.x = null;
    }
}

