/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.dataset.series.xy.interval;

import com.thecoderscorner.groovychart.chart.BeanBuilder;
import com.thecoderscorner.groovychart.chart.Buildable;
import com.thecoderscorner.groovychart.chart.ChartBuilder;
import com.thecoderscorner.groovychart.dataset.series.xy.interval.TimeSeriesCollectionBuilder;
import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.general.Series;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class TimeSeriesBuilder
extends BeanBuilder
implements Buildable {
    private static final Logger logger = Logger.getLogger(TimeSeriesBuilder.class.getPackage().getName());
    private Object parent;
    private Map beanMap;
    private Map addValue = null;
    private TimeSeries series;
    private String name;
    private String domain;
    private String range;
    private String timePeriodClass = "org.jfree.data.time.Day";

    public TimeSeriesBuilder() {
        try {
            this.setBeanClass(TimeSeries.class);
        }
        catch (IntrospectionException introspectionException) {
            logger.log(Level.WARNING, introspectionException.getMessage(), introspectionException);
        }
    }

    public Series getSeries() {
        return this.series;
    }

    public TimeSeries getTimeSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.series = (TimeSeries)series;
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        String string;
        if (logger.isLoggable(Level.FINE)) {
            logger.finest("TimeSeriesBuilder: " + object + ", " + map + ", " + object2);
        }
        if ((string = object.toString()).equalsIgnoreCase("timeSeries")) {
            if (object2 != null) {
                this.series = (TimeSeries)object2;
            } else if (map != null) {
                if (map.containsKey("series")) {
                    this.series = (TimeSeries)map.get(this.series);
                } else {
                    if (map.containsKey("name")) {
                        this.name = (String)map.get("name");
                    }
                    if (map.containsKey("domain")) {
                        this.domain = (String)map.get("domain");
                    }
                    if (map.containsKey("range")) {
                        this.range = (String)map.get("range");
                    }
                    if (map.containsKey("timePeriodClass")) {
                        this.timePeriodClass = (String)map.get("timePeriodClass");
                    }
                }
                this.beanMap = new HashMap(map);
                this.beanMap.remove("series");
                this.beanMap.remove("name");
                this.beanMap.remove("domain");
                this.beanMap.remove("range");
                this.beanMap.remove("timePeriodClass");
            }
        } else if (string.equalsIgnoreCase("add")) {
            this.addValue = map;
        }
    }

    @Override
    public void setChartBuilder(ChartBuilder chartBuilder) {
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public void nodeCompleted(Object object) {
        TimeSeriesCollectionBuilder timeSeriesCollectionBuilder = null;
        try {
            if (object != null && object instanceof TimeSeriesCollectionBuilder) {
                timeSeriesCollectionBuilder = (TimeSeriesCollectionBuilder)object;
            }
            if (this.series == null) {
                this.series = new TimeSeries((Comparable)((Object)this.name), this.domain, this.range, Class.forName(this.timePeriodClass));
                this.setProperties(this.series, this.beanMap);
            }
            if (this.addValue != null) {
                boolean bl = false;
                if (this.addValue.containsKey("notify")) {
                    bl = Boolean.valueOf((String)this.addValue.get("notify"));
                }
                this.series.add((RegularTimePeriod)this.addValue.get("period"), ((Number)this.addValue.get("value")).doubleValue(), bl);
                this.addValue = null;
            }
            if (timeSeriesCollectionBuilder != null) {
                timeSeriesCollectionBuilder.addSeries(this.series);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, throwable.getMessage(), throwable);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String string) {
        this.range = string;
    }

    public String getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public void setTimePeriodClass(String string) {
        this.timePeriodClass = string;
    }
}

