/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.dataset.series.xy;

import com.thecoderscorner.groovychart.dataset.BaseDatasetBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYDataset;

public class DefaultXYDatasetBuilder
extends BaseDatasetBuilder {
    private static final Logger logger = Logger.getLogger(DefaultXYDatasetBuilder.class.getPackage().getName());
    private String seriesTitle;
    private double[] x;
    private double[] y;
    private DefaultXYDataset xyDataset = new DefaultXYDataset();

    @Override
    public Dataset getDataset() {
        return this.xyDataset;
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("DefaultXYDatasetBuilder: " + object + ", " + map + ", " + object2);
            if (object2 != null) {
                logger.fine("Value object = " + object2.getClass());
            }
        }
        String string = object.toString();
        if (object2 != null && object2 instanceof DefaultXYDataset) {
            this.xyDataset = (DefaultXYDataset)object2;
        } else if (string.equalsIgnoreCase("series")) {
            if (this.seriesTitle != null) {
                // empty if block
            }
            if (object2 == null) {
                object2 = map.get("name");
            }
            this.seriesTitle = object2.toString();
        } else if (string.equalsIgnoreCase("X")) {
            List list = (List)object2;
            this.x = new double[list.size()];
            Iterator iterator = ((List)object2).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.x[n] = ((Number)iterator.next()).doubleValue();
                ++n;
            }
            if (this.seriesTitle != null && this.y != null) {
                this.addSeries();
            }
        } else if (string.equalsIgnoreCase("Y")) {
            List list = (List)object2;
            this.y = new double[list.size()];
            Iterator iterator = ((List)object2).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.y[n] = ((Number)iterator.next()).doubleValue();
                ++n;
            }
            if (this.seriesTitle != null && this.x != null) {
                this.addSeries();
            }
        }
    }

    private void addSeries() {
        double[][] dArrayArray = new double[][]{this.x, this.y};
        this.xyDataset.addSeries((Comparable)((Object)this.seriesTitle), (double[][])dArrayArray);
        this.seriesTitle = null;
        this.y = null;
        this.x = null;
    }

    public DefaultXYDataset getDefaultXYDataset() {
        return this.xyDataset;
    }

    public void setDefaultXYDataset(DefaultXYDataset defaultXYDataset) {
        this.xyDataset = defaultXYDataset;
    }
}

