/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.dataset.category;

import com.thecoderscorner.groovychart.dataset.BaseDatasetBuilder;
import java.sql.Connection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.general.Dataset;
import org.jfree.data.jdbc.JDBCCategoryDataset;

public class JDBCCategoryDatasetBuilder
extends BaseDatasetBuilder {
    private static final Logger logger = Logger.getLogger(JDBCCategoryDatasetBuilder.class.getPackage().getName());
    private Connection connection;
    private String url;
    private String driverName;
    private String user;
    private String password;
    private String query;
    private boolean transpose = false;
    private JDBCCategoryDataset categoryDataset = null;

    @Override
    public Dataset getDataset() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JDBCCategoryDatasetBuilder: getDataset()");
        }
        return this.getJDBCCategoryDataset();
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JDBCCategoryDatasetBuilder: method=" + object + ", " + map + ", " + object2);
        }
        if (object2 != null) {
            this.categoryDataset = (JDBCCategoryDataset)object2;
        } else {
            Boolean bl;
            String string = object.toString();
            String string2 = (String)map.get("user");
            if (string2 != null) {
                this.user = string2;
            }
            if ((string2 = (String)map.get("passwd")) != null) {
                this.password = string2;
            }
            if ((string2 = (String)map.get("url")) != null) {
                this.url = string2;
            }
            if ((string2 = (String)map.get("driverName")) != null) {
                this.driverName = string2;
            }
            if ((string2 = (String)map.get("query")) != null) {
                this.query = string2;
            }
            if ((bl = (Boolean)map.get("transpose")).booleanValue()) {
                this.transpose = bl;
            }
            this.connection = (Connection)map.get("conn");
            if (string.equalsIgnoreCase("query")) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Query: " + object2.toString());
                }
                this.query = object2.toString();
                if (this.categoryDataset != null) {
                    this.categoryDataset.executeQuery(this.query);
                }
            }
        }
    }

    public JDBCCategoryDataset getJDBCCategoryDataset() {
        if (this.categoryDataset == null) {
            try {
                this.categoryDataset = this.connection != null ? new JDBCCategoryDataset(this.connection) : new JDBCCategoryDataset(this.url, this.driverName, this.user, this.password);
                this.categoryDataset.setTranspose(this.transpose);
                if (this.query != null) {
                    this.categoryDataset.executeQuery(this.query);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, throwable.getMessage(), throwable);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("JDBCCategoryDatasetBuilder: get dataset()");
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Dataset = " + this.categoryDataset);
        }
        return this.categoryDataset;
    }

    public void setJDBCCategoryDataset(JDBCCategoryDataset jDBCCategoryDataset) {
        this.categoryDataset = jDBCCategoryDataset;
    }
}

