/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.chart;

import com.thecoderscorner.groovychart.axis.CategoryAxisBuilder;
import com.thecoderscorner.groovychart.axis.DateAxisBuilder;
import com.thecoderscorner.groovychart.axis.DomainAxisBuilder;
import com.thecoderscorner.groovychart.axis.NumberAxisBuilder;
import com.thecoderscorner.groovychart.axis.RangeAxisBuilder;
import com.thecoderscorner.groovychart.chart.AreaChart;
import com.thecoderscorner.groovychart.chart.BarChart;
import com.thecoderscorner.groovychart.chart.BarChart3D;
import com.thecoderscorner.groovychart.chart.BoxAndWhiskerChart;
import com.thecoderscorner.groovychart.chart.BubbleChart;
import com.thecoderscorner.groovychart.chart.Buildable;
import com.thecoderscorner.groovychart.chart.CandlestickChart;
import com.thecoderscorner.groovychart.chart.Chart;
import com.thecoderscorner.groovychart.chart.Chartable;
import com.thecoderscorner.groovychart.chart.GanttChart;
import com.thecoderscorner.groovychart.chart.HighLowChart;
import com.thecoderscorner.groovychart.chart.HistorgramChart;
import com.thecoderscorner.groovychart.chart.LineChart;
import com.thecoderscorner.groovychart.chart.LineChart3D;
import com.thecoderscorner.groovychart.chart.MultiplePieChart;
import com.thecoderscorner.groovychart.chart.MultiplePieChart3D;
import com.thecoderscorner.groovychart.chart.PieChart;
import com.thecoderscorner.groovychart.chart.PieChart3D;
import com.thecoderscorner.groovychart.chart.PieChartDiff;
import com.thecoderscorner.groovychart.chart.PolarChart;
import com.thecoderscorner.groovychart.chart.RingChart;
import com.thecoderscorner.groovychart.chart.ScatterPlot;
import com.thecoderscorner.groovychart.chart.StackedAreaChart;
import com.thecoderscorner.groovychart.chart.StackedBarChart;
import com.thecoderscorner.groovychart.chart.StackedBarChart3D;
import com.thecoderscorner.groovychart.chart.StackedXYAreaChart;
import com.thecoderscorner.groovychart.chart.TimeseriesChart;
import com.thecoderscorner.groovychart.chart.WaferMapChart;
import com.thecoderscorner.groovychart.chart.WaterfallChart;
import com.thecoderscorner.groovychart.chart.WindplotChart;
import com.thecoderscorner.groovychart.chart.XYAreaChart;
import com.thecoderscorner.groovychart.chart.XYBarChart;
import com.thecoderscorner.groovychart.chart.XYChart;
import com.thecoderscorner.groovychart.chart.XYLineChart;
import com.thecoderscorner.groovychart.chart.XYStepAreaChart;
import com.thecoderscorner.groovychart.chart.XYStepChart;
import com.thecoderscorner.groovychart.dataset.category.DefaultCategorySetBuilder;
import com.thecoderscorner.groovychart.dataset.pie.DefaultPieDatasetBuilder;
import com.thecoderscorner.groovychart.dataset.series.xy.DefaultHighLowDatasetBuilder;
import com.thecoderscorner.groovychart.dataset.series.xy.DefaultXYDatasetBuilder;
import com.thecoderscorner.groovychart.dataset.series.xy.interval.NormalizedTimeSeriesCollectionBuilder;
import com.thecoderscorner.groovychart.dataset.series.xy.interval.TimeSeriesBuilder;
import com.thecoderscorner.groovychart.dataset.series.xy.interval.TimeSeriesCollectionBuilder;
import com.thecoderscorner.groovychart.dataset.series.xy.interval.XYSeriesCollectionBuilder;
import com.thecoderscorner.groovychart.dataset.series.xyz.DefaultXYZDatasetBuilder;
import com.thecoderscorner.groovychart.dataset.statistics.DefaultBoxAndWhiskerDatasetBuilder;
import com.thecoderscorner.groovychart.plot.CategoryPlotBuilder;
import com.thecoderscorner.groovychart.plot.PiePlotBuilder;
import com.thecoderscorner.groovychart.plot.XYPlotBuilder;
import com.thecoderscorner.groovychart.renderer.GrayPaintScaleBuilder;
import com.thecoderscorner.groovychart.renderer.LookupPaintScaleBuilder;
import com.thecoderscorner.groovychart.renderer.category.BarRendererBuilder;
import com.thecoderscorner.groovychart.renderer.category.BoxAndWhiskerRendererBuilder;
import com.thecoderscorner.groovychart.renderer.category.StackedBarRendererBuilder;
import com.thecoderscorner.groovychart.renderer.xy.InbuiltRendererBuilder;
import com.thecoderscorner.groovychart.renderer.xy.XYBlockRendererBuilder;
import com.thecoderscorner.groovychart.renderer.xy.XYLineAndShapeRendererBuilder;
import com.thecoderscorner.groovychart.util.TextTitleBuilder;
import groovy.util.BuilderSupport;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ChartBuilder
extends BuilderSupport {
    private static final Logger logger = Logger.getLogger(ChartBuilder.class.getPackage().getName());
    Chartable chartable;
    private List<Buildable> nodeStack = new ArrayList<Buildable>();
    private static HashMap<String, Class> processClasses = new HashMap();

    protected void nodeCompleted(Object object, Object object2) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("nodeCompleted, parent=" + object + " child=" + object2);
        }
        if (object2 instanceof Buildable) {
            ((Buildable)object2).nodeCompleted(object);
        }
        if (object2 instanceof Buildable && object != object2) {
            this.nodeStack.remove(object2);
        }
    }

    protected void setParent(Object object, Object object2) {
        if (object2 instanceof Buildable) {
            ((Buildable)object2).setParent(object);
        }
    }

    protected Object createNode(Object object) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ChartBuilder: createNode(name=" + object + ", " + "map= null, " + "value=null)");
        }
        return this.createNode(object, null, null);
    }

    protected Object createNode(Object object, Object object2) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ChartBuilder: createNode(name=" + object + ", " + "map=null, " + "value=" + object2 + ")");
        }
        return this.createNode(object, null, object2);
    }

    protected Object createNode(Object object, Map map) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ChartBuilder: createNode(name=" + object + ", " + "map=" + map + ", " + "value=null)");
        }
        return this.createNode(object, map, null);
    }

    protected Object createNode(Object object, Map map, Object object2) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("ChartBuilder: createNode(name=" + object + ", " + "map=" + map + ", " + "value=" + object2 + ")");
        }
        Class clazz = processClasses.get(object.toString().toLowerCase());
        try {
            if (clazz == null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("ChartBuilder: '" + object.toString() + "' process last node");
                }
                this.attemptOnParent(object, map, object2);
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("ChartBuilder: process = " + clazz);
                }
                Buildable buildable = (Buildable)clazz.newInstance();
                buildable.setChartBuilder(this);
                buildable.setName(object.toString());
                buildable.processNode(object, map, object2);
                this.nodeStack.add(buildable);
            }
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        return this.getLastNode();
    }

    private void attemptOnParent(Object object, Map map, Object object2) throws Exception {
        if (this.nodeStack.size() > 0) {
            this.nodeStack.get(this.nodeStack.size() - 1).processNode(object, map, object2);
        }
    }

    public void chartAsPNG(OutputStream outputStream, int n, int n2) throws IOException {
        BufferedImage bufferedImage = this.chartable.getChart().createBufferedImage(n, n2);
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
    }

    public Object getLastNode() {
        if (this.nodeStack.size() > 0) {
            return this.nodeStack.get(this.nodeStack.size() - 1);
        }
        return null;
    }

    public Chartable getUnderlyingChart() {
        return this.chartable;
    }

    static {
        processClasses.put("chart", Chart.class);
        processClasses.put("areachart", AreaChart.class);
        processClasses.put("barchart", BarChart.class);
        processClasses.put("barchart3d", BarChart3D.class);
        processClasses.put("boxandwhiskerchart", BoxAndWhiskerChart.class);
        processClasses.put("bubblechart", BubbleChart.class);
        processClasses.put("candlestickchart", CandlestickChart.class);
        processClasses.put("ganttchart", GanttChart.class);
        processClasses.put("highlowchart", HighLowChart.class);
        processClasses.put("historgramchart", HistorgramChart.class);
        processClasses.put("linechart", LineChart.class);
        processClasses.put("linechart3d", LineChart3D.class);
        processClasses.put("multiplepiechart", MultiplePieChart.class);
        processClasses.put("multiplepiechart3d", MultiplePieChart3D.class);
        processClasses.put("piechart", PieChart.class);
        processClasses.put("piechart3d", PieChart3D.class);
        processClasses.put("piechartdiff", PieChartDiff.class);
        processClasses.put("polarchart", PolarChart.class);
        processClasses.put("ringchart", RingChart.class);
        processClasses.put("scatterplot", ScatterPlot.class);
        processClasses.put("stackedareachart", StackedAreaChart.class);
        processClasses.put("stackedbarchart", StackedBarChart.class);
        processClasses.put("stackedbarchart3d", StackedBarChart3D.class);
        processClasses.put("stackedxyareachart", StackedXYAreaChart.class);
        processClasses.put("timeserieschart", TimeseriesChart.class);
        processClasses.put("wafermapchart", WaferMapChart.class);
        processClasses.put("waterfallchart", WaterfallChart.class);
        processClasses.put("windplotchart", WindplotChart.class);
        processClasses.put("xyareachart", XYAreaChart.class);
        processClasses.put("xybarchart", XYBarChart.class);
        processClasses.put("xychart", XYChart.class);
        processClasses.put("xylinechart", XYLineChart.class);
        processClasses.put("xystepareachart", XYStepAreaChart.class);
        processClasses.put("xystepchart", XYStepChart.class);
        processClasses.put("defaultboxandwhiskercategorydataset", DefaultBoxAndWhiskerDatasetBuilder.class);
        processClasses.put("defaultcategorydataset", DefaultCategorySetBuilder.class);
        processClasses.put("defaulthighlowdataset", DefaultHighLowDatasetBuilder.class);
        processClasses.put("defaultxydataset", DefaultXYDatasetBuilder.class);
        processClasses.put("defaultxyzdataset", DefaultXYZDatasetBuilder.class);
        processClasses.put("defaultpiedataset", DefaultPieDatasetBuilder.class);
        processClasses.put("timeseriescollection", TimeSeriesCollectionBuilder.class);
        processClasses.put("timeseries", TimeSeriesBuilder.class);
        processClasses.put("normalizedtimeseriescollection", NormalizedTimeSeriesCollectionBuilder.class);
        processClasses.put("xyseries", XYSeriesCollectionBuilder.class);
        processClasses.put("xyplot", XYPlotBuilder.class);
        processClasses.put("categoryplot", CategoryPlotBuilder.class);
        processClasses.put("pieplot", PiePlotBuilder.class);
        processClasses.put("dateaxis", DateAxisBuilder.class);
        processClasses.put("numberaxis", NumberAxisBuilder.class);
        processClasses.put("categoryaxis", CategoryAxisBuilder.class);
        processClasses.put("domainaxis", DomainAxisBuilder.class);
        processClasses.put("rangeaxis", RangeAxisBuilder.class);
        processClasses.put("lookuppaintscale", LookupPaintScaleBuilder.class);
        processClasses.put("graypaintscale", GrayPaintScaleBuilder.class);
        processClasses.put("xyblockrenderer", XYBlockRendererBuilder.class);
        processClasses.put("xylineandshaperenderer", XYLineAndShapeRendererBuilder.class);
        processClasses.put("stackedbarrenderer", StackedBarRendererBuilder.class);
        processClasses.put("barrenderer", BarRendererBuilder.class);
        processClasses.put("boxandwhiskerrenderer", BoxAndWhiskerRendererBuilder.class);
        processClasses.put("renderer", InbuiltRendererBuilder.class);
        processClasses.put("titletext", TextTitleBuilder.class);
    }
}

