/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.chart;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class BeanBuilder {
    private static final Logger logger = Logger.getLogger(BeanBuilder.class.getPackage().getName());
    protected HashMap<String, PropertyDescriptor> propertyMap;
    protected Class beanClass;

    public BeanBuilder() {
    }

    public BeanBuilder(Class clazz) throws IntrospectionException {
        this.setBeanClass(clazz);
    }

    public void setBeanClass(Class clazz) throws IntrospectionException {
        this.beanClass = clazz;
        this.loadBean();
    }

    public boolean isIndexedProperty(String string) {
        return this.propertyMap.get(string) instanceof IndexedPropertyDescriptor;
    }

    public boolean hasProperty(String string) {
        return this.propertyMap.containsKey(string);
    }

    public void setProperties(Object object, Map map) throws IllegalAccessException, InvocationTargetException {
        if (map == null) {
            return;
        }
        for (String string : map.keySet()) {
            Object v = map.get(string);
            if (this.isIndexedProperty(string)) {
                Map map2 = (Map)v;
                for (Number number : map2.keySet()) {
                    Object v2 = map2.get(number);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Setting Indexed Property: " + string + ": " + number + " = " + v2);
                    }
                    this.setProperty(object, string, number, v2);
                }
                continue;
            }
            this.setProperty(object, string, v);
        }
    }

    public void setProperty(Object object, String string, Number number, Object object2) throws IllegalAccessException, InvocationTargetException {
        this.setProperty(object, string, number.intValue(), object2);
    }

    public void setProperty(Object object, String string, int n, Object object2) throws IllegalAccessException, InvocationTargetException {
        IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)this.propertyMap.get(string);
        if (indexedPropertyDescriptor == null) {
            throw new IllegalArgumentException("Invalid property: " + string);
        }
        Method method = indexedPropertyDescriptor.getIndexedWriteMethod();
        Class<?> clazz = indexedPropertyDescriptor.getIndexedPropertyType();
        Object object3 = this.getPropertyTypeValue(clazz, object2);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Invoking: " + method.getName() + " Index = " + n + " arg = " + object3);
        }
        method.invoke(object, new Integer(n), object3);
    }

    public void setProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        PropertyDescriptor propertyDescriptor = this.propertyMap.get(string);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("Invalid property: " + string);
        }
        Method method = propertyDescriptor.getWriteMethod();
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz == null) {
            logger.warning("Cannot determine type for property: " + string);
            method.invoke(object, object2);
            return;
        }
        Object object3 = this.getPropertyTypeValue(clazz, object2);
        method.invoke(object, object3);
    }

    private Object getPropertyTypeValue(Class clazz, Object object) {
        if (clazz.equals(String.class)) {
            return object.toString();
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            Boolean bl = null;
            bl = object instanceof Boolean ? (Boolean)object : Boolean.valueOf(Boolean.parseBoolean(object.toString()));
            return bl;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            Short s = null;
            s = object instanceof Short ? (Short)object : Short.valueOf(Short.parseShort(object.toString()));
            return s;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            Integer n = null;
            n = object instanceof Integer ? (Integer)object : Integer.valueOf(Integer.parseInt(object.toString()));
            return n;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            Long l = null;
            l = object instanceof Long ? (Long)object : Long.valueOf(Long.parseLong(object.toString()));
            return l;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            Float f = null;
            f = object instanceof Float ? (Float)object : Float.valueOf(Float.parseFloat(object.toString()));
            return f;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            Double d = null;
            d = object instanceof Double ? (Double)object : Double.valueOf(Double.parseDouble(object.toString()));
            return d;
        }
        return object;
    }

    protected void loadBean() throws IntrospectionException {
        this.propertyMap = new HashMap();
        BeanInfo beanInfo = Introspector.getBeanInfo(this.beanClass);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            this.propertyMap.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        try {
            BeanBuilder beanBuilder = new BeanBuilder();
            beanBuilder.setBeanClass(XYLineAndShapeRenderer.class);
            XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
            beanBuilder.setProperty((Object)xYLineAndShapeRenderer, "seriesPaint", 0, (Object)Color.RED);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }
}

