/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.renderer.xy;

import com.thecoderscorner.groovychart.chart.BeanBuilder;
import com.thecoderscorner.groovychart.chart.Buildable;
import com.thecoderscorner.groovychart.chart.ChartBuilder;
import com.thecoderscorner.groovychart.plot.Plotable;
import com.thecoderscorner.groovychart.renderer.Renderable;
import com.thecoderscorner.groovychart.util.AutoBeanPropertySetter;
import java.awt.Paint;
import java.awt.Shape;
import java.beans.IntrospectionException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class XYLineAndShapeRendererBuilder
extends BeanBuilder
implements Buildable,
Renderable {
    private static final Logger logger = Logger.getLogger(XYLineAndShapeRendererBuilder.class.getPackage().getName());
    XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
    Integer index;
    private Object parent;
    private String name;

    public XYLineAndShapeRendererBuilder() {
        try {
            this.setBeanClass(XYLineAndShapeRenderer.class);
        }
        catch (IntrospectionException introspectionException) {
            logger.log(Level.WARNING, introspectionException.getMessage(), introspectionException);
        }
    }

    @Override
    public void setChartBuilder(ChartBuilder chartBuilder) {
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        String string = object.toString();
        if (object2 != null && object2 instanceof XYLineAndShapeRenderer) {
            this.renderer = (XYLineAndShapeRenderer)object2;
        } else if (string.equalsIgnoreCase("XYLineAndShapeRenderer")) {
            this.setProperties(this.renderer, map);
        } else if (string.equalsIgnoreCase("seriesPaint") && object2 != null) {
            Integer n = (Integer)object2;
            Paint paint = (Paint)map.get("paint");
            this.renderer.setSeriesPaint(n.intValue(), paint);
        } else if (string.equalsIgnoreCase("seriesShape") && object2 != null) {
            Integer n = (Integer)object2;
            Shape shape = (Shape)map.get("shape");
            this.renderer.setSeriesShape(n.intValue(), shape);
        } else if (string.equalsIgnoreCase("index")) {
            this.index = (Integer)object2;
        } else {
            AutoBeanPropertySetter.autoSetProp(this.renderer, string, object2);
        }
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public void nodeCompleted(Object object) {
        if (object != null && object instanceof Plotable) {
            if (this.index == null) {
                ((XYPlot)((Plotable)object).getPlot()).setRenderer((XYItemRenderer)this.renderer);
            } else {
                ((XYPlot)((Plotable)object).getPlot()).setRenderer(this.index.intValue(), (XYItemRenderer)this.renderer);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public XYLineAndShapeRenderer getRenderer() {
        return this.renderer;
    }
}

