/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.chart;

import com.thecoderscorner.groovychart.chart.BeanBuilder;
import com.thecoderscorner.groovychart.chart.Buildable;
import com.thecoderscorner.groovychart.chart.ChartBuilder;
import com.thecoderscorner.groovychart.chart.Chartable;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.Dataset;

public abstract class BaseChart
extends BeanBuilder
implements Chartable,
Buildable {
    private static final Logger logger = Logger.getLogger(BeanBuilder.class.getPackage().getName());
    protected ChartBuilder chartBuilder;
    protected Object parent;
    protected String name;
    protected Map chartProperties = new HashMap();
    private BeanBuilder bb = new BeanBuilder();
    private JFreeChart theChart;
    private String title;
    private Dataset dataset;
    private TextTitle textTitle;
    private Plot plot;

    protected BaseChart() {
        try {
            this.setBeanClass(this.getClass());
            this.bb.setBeanClass(JFreeChart.class);
        }
        catch (IntrospectionException introspectionException) {
            logger.log(Level.WARNING, introspectionException.getMessage(), introspectionException);
        }
    }

    @Override
    public JFreeChart getChart() {
        if (this.theChart == null) {
            this.theChart = this.createChart();
        }
        return this.theChart;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public void setChartBuilder(ChartBuilder chartBuilder) {
        this.chartBuilder = chartBuilder;
        this.chartBuilder.chartable = this;
    }

    public JFreeChart setExtraProperties(JFreeChart jFreeChart) {
        if (this.getTextTitle() != null) {
            jFreeChart.setTitle(this.getTextTitle());
        }
        if (this.chartProperties.size() > 0) {
            try {
                this.bb.setProperties(jFreeChart, this.chartProperties);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return jFreeChart;
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        if (map != null) {
            HashMap hashMap = new HashMap(map);
            for (String string : map.keySet()) {
                if (this.hasProperty(string)) continue;
                this.chartProperties.put(string, hashMap.remove(string));
            }
            this.setProperties(this, hashMap);
        }
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public void nodeCompleted(Object object) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public TextTitle getTextTitle() {
        return this.textTitle;
    }

    public void setTextTitle(TextTitle textTitle) {
        this.textTitle = textTitle;
    }

    public String toString() {
        return this.name;
    }

    public Plot getPlot() {
        return this.plot;
    }

    @Override
    public void setPlot(Plot plot) {
        this.plot = plot;
    }
}

