/*
 * Decompiled with CFR 0.152.
 */
package com.thecoderscorner.groovychart.axis;

import com.thecoderscorner.groovychart.axis.AxisSettable;
import com.thecoderscorner.groovychart.chart.BeanBuilder;
import com.thecoderscorner.groovychart.chart.Buildable;
import com.thecoderscorner.groovychart.chart.ChartBuilder;
import java.beans.IntrospectionException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;

public class NumberAxisBuilder
extends BeanBuilder
implements Buildable {
    private static final Logger logger = Logger.getLogger(NumberAxisBuilder.class.getPackage().getName());
    private NumberAxis axis = new NumberAxis();
    private boolean domain;
    private Object parent;
    private String name;

    public NumberAxisBuilder() {
        try {
            this.setBeanClass(NumberAxis.class);
        }
        catch (IntrospectionException introspectionException) {
            logger.log(Level.WARNING, introspectionException.getMessage(), introspectionException);
        }
    }

    @Override
    public void setChartBuilder(ChartBuilder chartBuilder) {
    }

    @Override
    public void processNode(Object object, Map map, Object object2) throws Exception {
        String string = object.toString();
        if (object2 != null) {
            this.axis = (NumberAxis)object2;
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("processNode: method = " + string);
            }
            if (string.equalsIgnoreCase("NumberAxis")) {
                this.setProperties(this.axis, map);
            }
        }
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object object) {
        this.parent = object;
    }

    @Override
    public void nodeCompleted(Object object) {
        if (object != null && object instanceof AxisSettable) {
            logger.finest("Setting axis on parent");
            ((AxisSettable)object).setAxis((Axis)this.axis);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public NumberAxis getAxis() {
        return this.axis;
    }
}

