/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.cassandra.CassandraAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.CassandraAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleCassandraAware
extends EclipseAnnotationHandler<CassandraAware> {
    private final EclipseCassandraAwareHandler handler = new EclipseCassandraAwareHandler();

    public void handle(AnnotationValues<CassandraAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(CassandraAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.cassandra.CassandraContributionHandler", (Annotation)source);
        this.handler.addCassandraProviderField(type);
        this.handler.addCassandraProviderAccessors(type);
        this.handler.addCassandraContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseCassandraAwareHandler
    extends CassandraAwareHandler<EclipseType> {
        private EclipseCassandraAwareHandler() {
        }
    }
}

