/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.sql.SQLNonTransientException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.JdbcAscii;
import org.apache.cassandra.cql.jdbc.TypedColumn;
import org.apache.cassandra.cql.jdbc.TypesMap;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.utils.ByteBufferUtil;

class ColumnDecoder {
    public static final ByteBuffer DEFAULT_KEY_NAME = ByteBufferUtil.bytes((String)"KEY");
    private final Map<String, CFamMeta> metadata = new HashMap<String, CFamMeta>();

    public ColumnDecoder(List<KsDef> defs) {
        for (KsDef ks : defs) {
            for (CfDef cf : ks.getCf_defs()) {
                this.metadata.put(String.format("%s.%s", ks.getName(), cf.getName()), new CFamMeta(cf));
            }
        }
    }

    protected AbstractJdbcType<?> getComparator(String keyspace, String columnFamily) {
        CFamMeta cf = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        AbstractJdbcType type = cf != null ? TypesMap.getTypeForComparator((String)cf.comparator) : null;
        return type == null ? null : type;
    }

    protected AbstractJdbcType<?> getDefaultValidator(String keyspace, String columnFamily) {
        CFamMeta cf = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        AbstractJdbcType type = cf != null ? TypesMap.getTypeForComparator((String)cf.defaultValidator) : null;
        return type == null ? null : type;
    }

    private AbstractJdbcType<?> getNameType(String keyspace, String columnFamily, ByteBuffer name) {
        CFamMeta cf = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        try {
            if (ByteBufferUtil.string((ByteBuffer)name).equalsIgnoreCase(ByteBufferUtil.string((ByteBuffer)cf.keyAlias))) {
                return JdbcAscii.instance;
            }
        }
        catch (CharacterCodingException e) {
            // empty catch block
        }
        return TypesMap.getTypeForComparator((String)cf.comparator);
    }

    private AbstractJdbcType<?> getValueType(String keyspace, String columnFamily, ByteBuffer name) {
        CFamMeta cf = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        if (cf == null) {
            return null;
        }
        try {
            if (ByteBufferUtil.string((ByteBuffer)name).equalsIgnoreCase(ByteBufferUtil.string((ByteBuffer)cf.keyAlias))) {
                return TypesMap.getTypeForComparator((String)cf.keyValidator);
            }
        }
        catch (CharacterCodingException e) {
            // empty catch block
        }
        AbstractJdbcType type = TypesMap.getTypeForComparator((String)cf.columnMeta.get(name));
        return type != null ? type : TypesMap.getTypeForComparator((String)cf.defaultValidator);
    }

    public AbstractJdbcType<?> getKeyValidator(String keyspace, String columnFamily) {
        CFamMeta cf = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        AbstractJdbcType type = cf != null ? TypesMap.getTypeForComparator((String)cf.keyValidator) : null;
        return type == null ? null : type;
    }

    public String colNameAsString(String keyspace, String columnFamily, ByteBuffer name) {
        AbstractJdbcType<?> comparator = this.getNameType(keyspace, columnFamily, name);
        return comparator.getString(name);
    }

    public TypedColumn makeCol(String keyspace, String columnFamily, Column column) {
        return new TypedColumn(column, this.getNameType(keyspace, columnFamily, column.name), this.getValueType(keyspace, columnFamily, column.name));
    }

    public TypedColumn makeKeyColumn(String keyspace, String columnFamily, byte[] key) throws SQLNonTransientException {
        CFamMeta cf = this.metadata.get(String.format("%s.%s", keyspace, columnFamily));
        if (cf == null) {
            throw new SQLNonTransientException(String.format("could not find decoder metadata for: %s.%s", keyspace, columnFamily));
        }
        Column column = new Column(cf.keyAlias).setValue(key).setTimestamp(-1L);
        return new TypedColumn(column, this.getNameType(keyspace, columnFamily, cf.keyAlias != null ? cf.keyAlias : DEFAULT_KEY_NAME), this.getValueType(keyspace, columnFamily, cf.keyAlias != null ? cf.keyAlias : DEFAULT_KEY_NAME));
    }

    private class CFamMeta {
        String comparator;
        String defaultValidator;
        ByteBuffer keyAlias;
        String keyValidator;
        Map<ByteBuffer, String> columnMeta = new HashMap<ByteBuffer, String>();

        private CFamMeta(CfDef cf) {
            this.comparator = cf.getComparator_type();
            this.defaultValidator = cf.getDefault_validation_class();
            this.keyAlias = cf.key_alias;
            this.keyValidator = cf.getKey_validation_class();
            for (ColumnDef colDef : cf.getColumn_metadata()) {
                this.columnMeta.put(colDef.name, colDef.getValidation_class());
            }
        }

        public String toString() {
            return String.format("CFamMeta(comparator=%s, defaultValidator=%s, keyAlias=%s, keyValidator=%s, columnMeta=%s)", this.comparator, this.defaultValidator, this.keyAlias, this.keyValidator, this.columnMeta);
        }
    }
}

