/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TypedColumn {
    private final Column rawColumn;
    private final Object value;
    private final String nameString;
    private final AbstractJdbcType<?> nameType;
    private final AbstractJdbcType<?> valueType;

    public TypedColumn(Column column, AbstractJdbcType<?> comparator, AbstractJdbcType<?> validator) {
        this.rawColumn = column;
        this.value = column.value == null || !column.value.hasRemaining() ? null : validator.compose(column.value);
        this.nameString = comparator.getString(column.name);
        this.nameType = comparator;
        this.valueType = validator;
    }

    public Column getRawColumn() {
        return this.rawColumn;
    }

    public Object getValue() {
        return this.value;
    }

    public String getNameString() {
        return this.nameString;
    }

    public String getValueString() {
        return this.valueType.getString(this.rawColumn.value);
    }

    public AbstractJdbcType getNameType() {
        return this.nameType;
    }

    public AbstractJdbcType getValueType() {
        return this.valueType;
    }

    public String toString() {
        return String.format("TypedColumn [rawColumn=%s, value=%s, nameString=%s, nameType=%s, valueType=%s]", this.displayRawColumn(this.rawColumn), this.value, this.nameString, this.nameType, this.valueType);
    }

    private String displayRawColumn(Column column) {
        String name;
        try {
            name = ByteBufferUtil.string((ByteBuffer)column.name);
        }
        catch (CharacterCodingException e) {
            name = "<binary>";
        }
        String value = column.value == null ? "<null>" : ByteBufferUtil.bytesToHex((ByteBuffer)column.value);
        return String.format("Column[name=%s, value=%s]", name, value);
    }
}

