/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.cassandra.cql.jdbc.Utils;

public class CassandraDataSource
implements DataSource {
    protected static final String description = "Cassandra Data Source";
    protected String serverName;
    protected int portNumber = 9160;
    protected String databaseName;
    protected String user;
    protected String password;
    protected String version = null;

    public CassandraDataSource(String host, int port, String keyspace, String user, String password, String version) {
        if (host != null) {
            this.setServerName(host);
        }
        if (port != -1) {
            this.setPortNumber(port);
        }
        if (version != null) {
            this.setVersion(version);
        }
        this.setDatabaseName(keyspace);
        this.setUser(user);
        this.setPassword(password);
    }

    public String getDescription() {
        return description;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        this.user = user;
        this.password = password;
        if (this.serverName == null) {
            throw new SQLNonTransientConnectionException("a 'host' name is required to build a Connection");
        }
        props.setProperty("serverName", this.serverName);
        props.setProperty("portNumber", "" + this.portNumber);
        if (this.databaseName != null) {
            props.setProperty("databaseName", this.databaseName);
        }
        if (user != null) {
            props.setProperty("user", user);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        if (this.version != null) {
            props.setProperty("cqlVersion", this.version);
        }
        String url = "jdbc:cassandra:" + Utils.createSubName(props);
        return DriverManager.getConnection(url, props);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        DriverManager.setLoginTimeout(timeout);
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        DriverManager.setLogWriter(writer);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(String.format("the Cassandra implementation does not support this method", new Object[0]));
    }

    static {
        try {
            Class.forName("org.apache.cassandra.cql.jdbc.CassandraDriver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

