/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.cassandra.cql.jdbc.AbstractCassandraConnection;
import org.apache.cassandra.cql.jdbc.CassandraDatabaseMetaData;
import org.apache.cassandra.cql.jdbc.CassandraPreparedStatement;
import org.apache.cassandra.cql.jdbc.CassandraStatement;
import org.apache.cassandra.cql.jdbc.ColumnDecoder;
import org.apache.cassandra.cql.jdbc.Utils;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraConnection
extends AbstractCassandraConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(CassandraConnection.class);
    public static final int DB_MAJOR_VERSION = 1;
    public static final int DB_MINOR_VERSION = 1;
    public static final String DB_PRODUCT_NAME = "Cassandra";
    public static final String DEFAULT_CQL_VERSION = "2.0.0";
    public static Compression defaultCompression = Compression.GZIP;
    private final boolean autoCommit = true;
    private final int transactionIsolation = 0;
    private Properties connectionProps;
    private Properties clientInfo = new Properties();
    private Set<Statement> statements = new ConcurrentSkipListSet<Statement>();
    private Cassandra.Client client;
    private TTransport transport;
    protected long timeOfLastFailure = 0L;
    protected int numFailures = 0;
    protected String username = null;
    protected String url = null;
    String currentKeyspace;
    ColumnDecoder decoder;

    public CassandraConnection(Properties props) throws SQLException {
        this.connectionProps = (Properties)props.clone();
        this.clientInfo = new Properties();
        this.url = "jdbc:cassandra:" + Utils.createSubName(props);
        try {
            String host = props.getProperty("serverName");
            int port = Integer.parseInt(props.getProperty("portNumber"));
            this.currentKeyspace = props.getProperty("databaseName", "system");
            this.username = props.getProperty("user");
            String password = props.getProperty("password");
            String version = props.getProperty("cqlVersion");
            TSocket socket = new TSocket(host, port);
            this.transport = new TFramedTransport((TTransport)socket);
            TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
            this.client = new Cassandra.Client((TProtocol)protocol);
            socket.open();
            if (this.username != null) {
                HashMap<String, String> credentials = new HashMap<String, String>();
                credentials.put("username", this.username);
                if (password != null) {
                    credentials.put("password", password);
                }
                AuthenticationRequest areq = new AuthenticationRequest(credentials);
                this.client.login(areq);
            }
            if (version != null) {
                this.client.set_cql_version(version);
                this.connectionProps.setProperty("activeCqlVersion", version);
            }
            this.decoder = new ColumnDecoder(this.client.describe_keyspaces());
            this.client.set_keyspace("system");
            this.client.set_keyspace(this.currentKeyspace);
            Object[] args = new Object[]{host, port, this.currentKeyspace, version == null ? DEFAULT_CQL_VERSION : version};
            logger.info("Connected to {}:{} using Keyspace {} and CQL version {}", args);
        }
        catch (InvalidRequestException e) {
            throw new SQLSyntaxErrorException(e);
        }
        catch (TException e) {
            throw new SQLNonTransientConnectionException(e);
        }
        catch (AuthenticationException e) {
            throw new SQLInvalidAuthorizationSpecException(e);
        }
        catch (AuthorizationException e) {
            throw new SQLInvalidAuthorizationSpecException(e);
        }
    }

    private final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLNonTransientConnectionException("method was called on a closed Connection");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public synchronized void close() throws SQLException {
        for (Statement statement : this.statements) {
            statement.close();
        }
        this.statements.clear();
        if (this.isConnected()) {
            this.disconnect();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("the Cassandra implementation is always in auto-commit mode");
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this, null, resultSetType, resultSetConcurrency);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this, null, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkNotClosed();
        return true;
    }

    public Properties getConnectionProps() {
        return this.connectionProps;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String label) throws SQLException {
        this.checkNotClosed();
        return this.clientInfo.getProperty(label);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return new CassandraDatabaseMetaData(this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return !this.isConnected();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkNotClosed();
        if (timeout < 0) {
            throw new SQLTimeoutException("the timeout value was less than zero");
        }
        return !this.isClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkNotClosed();
        return sql;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkNotClosed();
        CassandraPreparedStatement statement = new CassandraPreparedStatement(this, sql);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support this method");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        throw new SQLFeatureNotSupportedException("the Cassandra implementation is always in auto-commit mode");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("the Cassandra implementation is always in auto-commit mode");
        }
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (props != null) {
            this.clientInfo = props;
        }
    }

    @Override
    public void setClientInfo(String key, String value) throws SQLClientInfoException {
        this.clientInfo.setProperty(key, value);
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
        if (level != 0) {
            throw new SQLFeatureNotSupportedException("the Cassandra implementation does not support transactions");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(String.format("no object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    protected CqlResult execute(String queryStr, Compression compression) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        this.currentKeyspace = Utils.determineCurrentKeyspace(queryStr, this.currentKeyspace);
        try {
            return this.client.execute_cql_query(Utils.compressQuery(queryStr, compression), compression);
        }
        catch (TException error) {
            ++this.numFailures;
            this.timeOfLastFailure = System.currentTimeMillis();
            throw error;
        }
    }

    protected CqlResult execute(String queryStr) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return this.execute(queryStr, defaultCompression);
    }

    protected CqlResult execute(int itemId, List<ByteBuffer> values) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        try {
            return this.client.execute_prepared_cql_query(itemId, values);
        }
        catch (TException error) {
            ++this.numFailures;
            this.timeOfLastFailure = System.currentTimeMillis();
            throw error;
        }
    }

    protected CqlPreparedResult prepare(String queryStr, Compression compression) throws InvalidRequestException, TException {
        try {
            return this.client.prepare_cql_query(Utils.compressQuery(queryStr, compression), compression);
        }
        catch (TException error) {
            ++this.numFailures;
            this.timeOfLastFailure = System.currentTimeMillis();
            throw error;
        }
    }

    protected CqlPreparedResult prepare(String queryStr) throws InvalidRequestException, TException {
        try {
            return this.prepare(queryStr, defaultCompression);
        }
        catch (TException error) {
            ++this.numFailures;
            this.timeOfLastFailure = System.currentTimeMillis();
            throw error;
        }
    }

    protected boolean removeStatement(Statement statement) {
        return this.statements.remove(statement);
    }

    protected void disconnect() {
        this.transport.close();
    }

    protected boolean isConnected() {
        return this.transport.isOpen();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CassandraConnection [connectionProps=");
        builder.append(this.connectionProps);
        builder.append("]");
        return builder.toString();
    }
}

