/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.apache.cassandra.cql.jdbc.JdbcBoolean;
import org.apache.cassandra.cql.jdbc.JdbcDate;
import org.apache.cassandra.cql.jdbc.JdbcInt32;
import org.apache.cassandra.cql.jdbc.JdbcInteger;
import org.apache.cassandra.cql.jdbc.JdbcLong;
import org.apache.cassandra.cql.jdbc.JdbcUTF8;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleObjects {
    private static final Logger LOG = LoggerFactory.getLogger(HandleObjects.class);
    private static final String BAD_MAPPING = "encountered object of class: %s, but only '%s' is supported to map to %s";
    private static final String STR_BOOL_NUMERIC = "String, Boolean, or a Numeric class";

    private static Long fromString(String source) throws SQLException {
        long millis = 0L;
        if (source.isEmpty() || source.toLowerCase().equals("now")) {
            return System.currentTimeMillis();
        }
        if (source.matches("^\\d+$")) {
            try {
                Long.parseLong(source);
            }
            catch (NumberFormatException e) {
                throw new SQLNonTransientException(String.format("unable to make long (for date) from:  '%s'", source), e);
            }
        }
        try {
            millis = DateUtils.parseDate((String)source, (String[])JdbcDate.iso8601Patterns).getTime();
        }
        catch (ParseException e1) {
            throw new SQLNonTransientException(String.format("unable to coerce '%s' to a  formatted date (long)", source), e1);
        }
        return millis;
    }

    private static final SQLException makeBadMapping(Class<?> badclass, String javatype, String jdbctype) {
        return new SQLNonTransientException(String.format(BAD_MAPPING, badclass, javatype, jdbctype));
    }

    private static final ByteBuffer javaObject(Object object) throws SQLException {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            out.close();
            bytes = bos.toByteArray();
        }
        catch (IOException e) {
            throw new SQLNonTransientException("Problem serializing the Java object", e);
        }
        return ByteBuffer.wrap(bytes);
    }

    private static final Integer objectToINTEGER(Class<? extends Object> objectClass, Object object) {
        if (objectClass == String.class) {
            return Integer.valueOf((String)object);
        }
        if (objectClass == Boolean.class) {
            return (Boolean)object == false ? 0 : 1;
        }
        if (objectClass == Integer.class) {
            return (Integer)object;
        }
        if (objectClass == BigInteger.class) {
            return ((BigInteger)object).intValue();
        }
        if (objectClass == Long.class) {
            return ((Long)object).intValue();
        }
        if (objectClass == Short.class) {
            return ((Short)object).intValue();
        }
        if (objectClass == Byte.class) {
            return ((Byte)object).intValue();
        }
        if (objectClass == Double.class) {
            return ((Double)object).intValue();
        }
        if (objectClass == Float.class) {
            return ((Float)object).intValue();
        }
        if (objectClass == BigDecimal.class) {
            return ((BigDecimal)object).intValue();
        }
        return null;
    }

    private static final Long objectToBIGINT(Class<? extends Object> objectClass, Object object) {
        if (objectClass == String.class) {
            return Long.valueOf((String)object);
        }
        if (objectClass == Boolean.class) {
            return (Boolean)object == false ? 0L : 1L;
        }
        if (objectClass == Integer.class) {
            return (long)((Integer)object);
        }
        if (objectClass == BigInteger.class) {
            return ((BigInteger)object).longValue();
        }
        if (objectClass == Long.class) {
            return (long)((Long)object);
        }
        if (objectClass == Short.class) {
            return ((Short)object).longValue();
        }
        if (objectClass == Byte.class) {
            return ((Byte)object).longValue();
        }
        if (objectClass == Double.class) {
            return ((Double)object).longValue();
        }
        if (objectClass == Float.class) {
            return ((Float)object).longValue();
        }
        if (objectClass == BigDecimal.class) {
            return ((BigDecimal)object).longValue();
        }
        return null;
    }

    private static final Long objectToDATEorTIMEorTIMESTAMP(Class<? extends Object> objectClass, Object object) throws SQLException {
        if (objectClass == String.class) {
            return HandleObjects.fromString((String)object);
        }
        if (objectClass == java.util.Date.class) {
            return ((java.util.Date)object).getTime();
        }
        if (objectClass == Date.class) {
            return ((Date)object).getTime();
        }
        if (objectClass == Time.class) {
            return ((Time)object).getTime();
        }
        if (objectClass == Timestamp.class) {
            return ((Timestamp)object).getTime();
        }
        return null;
    }

    private static final Boolean objectToBOOLEAN(Class<? extends Object> objectClass, Object object) {
        if (objectClass == String.class) {
            return Boolean.valueOf((String)object);
        }
        if (objectClass == Boolean.class) {
            return (Boolean)object;
        }
        if (objectClass == Integer.class) {
            return (Integer)object != 0;
        }
        if (objectClass == BigInteger.class) {
            return ((BigInteger)object).intValue() != 0;
        }
        if (objectClass == Long.class) {
            return (Long)object != 0L;
        }
        if (objectClass == Short.class) {
            return (Short)object != 0;
        }
        if (objectClass == Byte.class) {
            return (Byte)object != 0;
        }
        if (objectClass == Double.class) {
            return Integer.valueOf(((Double)object).intValue()) != 0;
        }
        if (objectClass == Float.class) {
            return Integer.valueOf(((Float)object).intValue()) != 0;
        }
        if (objectClass == BigDecimal.class) {
            return Integer.valueOf(((BigDecimal)object).intValue()) != 0;
        }
        return null;
    }

    private static final BigInteger objectToBITorTINYINTorSMALLINTorNUMERIC(Class<? extends Object> objectClass, Object object) {
        if (objectClass == String.class) {
            return new BigInteger((String)object);
        }
        if (objectClass == Boolean.class) {
            return (Boolean)object == false ? BigInteger.ZERO : BigInteger.ONE;
        }
        if (objectClass == Integer.class) {
            return BigInteger.valueOf(((Integer)object).intValue());
        }
        if (objectClass == BigInteger.class) {
            return (BigInteger)object;
        }
        if (objectClass == Long.class) {
            return BigInteger.valueOf((Long)object);
        }
        if (objectClass == Short.class) {
            return BigInteger.valueOf(((Short)object).longValue());
        }
        if (objectClass == Byte.class) {
            return BigInteger.valueOf(((Byte)object).longValue());
        }
        if (objectClass == Double.class) {
            return BigInteger.valueOf(((Double)object).longValue());
        }
        if (objectClass == Float.class) {
            return BigInteger.valueOf(((Float)object).longValue());
        }
        if (objectClass == BigDecimal.class) {
            return BigInteger.valueOf(((BigDecimal)object).intValue());
        }
        return null;
    }

    public static final ByteBuffer makeBytes(Object object, int targetSqlType, int scaleOrLength) throws SQLException {
        Class<Object> objectClass = object.getClass();
        switch (targetSqlType) {
            case -6: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "TINYINT");
            }
            case 5: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "SMALLINT");
            }
            case 4: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "INTEGER");
            }
            case -5: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "BIGINT");
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "the floating point types");
            }
            case 2: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "NUMERIC");
            }
            case -7: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "BIT");
            }
            case 16: {
                if (objectClass == String.class || objectClass == Boolean.class || Number.class.isAssignableFrom(object.getClass())) break;
                throw HandleObjects.makeBadMapping(objectClass, STR_BOOL_NUMERIC, "BOOLEAN");
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (objectClass.isAssignableFrom(String.class)) break;
                throw HandleObjects.makeBadMapping(objectClass, "String", "the various VARCHAR types");
            }
            case -4: 
            case -3: 
            case -2: {
                if (objectClass.isAssignableFrom(ByteBuffer.class) || objectClass.getSimpleName().equals("byte[]")) break;
                throw HandleObjects.makeBadMapping(objectClass, "ByteBuffer or byte[]", "the BINARY Types");
            }
            case 91: {
                if (objectClass == String.class || objectClass == java.util.Date.class || objectClass == Date.class || objectClass == Timestamp.class) break;
                throw HandleObjects.makeBadMapping(objectClass, "String, Date(java and sql) or Timestamp types", "DATE");
            }
            case 92: {
                if (objectClass == String.class || objectClass == java.util.Date.class || objectClass == Time.class || objectClass == Timestamp.class) break;
                throw HandleObjects.makeBadMapping(objectClass, "String, Date (java), Time or Timestamp types", "TIME");
            }
            case 93: {
                if (objectClass == String.class || objectClass == java.util.Date.class || objectClass == Date.class || objectClass == Timestamp.class) break;
                throw HandleObjects.makeBadMapping(objectClass, "String, Date(java and sql) or Timestamp types", "TIMESTAMP");
            }
            case 70: {
                if (objectClass == URL.class) break;
                throw HandleObjects.makeBadMapping(objectClass, "a URL type", "DATALINK");
            }
            case 2000: {
                break;
            }
            case -8: {
                if (objectClass == RowId.class) break;
                throw HandleObjects.makeBadMapping(objectClass, "a RowId type", "ROWID");
            }
            default: {
                throw new SQLNonTransientException("Unsupported transformation to Jdbc Type: " + targetSqlType);
            }
        }
        switch (targetSqlType) {
            case -7: {
                BigInteger bitvalue = HandleObjects.objectToBITorTINYINTorSMALLINTorNUMERIC(objectClass, object);
                assert (bitvalue != null);
                return JdbcInteger.instance.decompose(bitvalue == BigInteger.ZERO ? BigInteger.ZERO : BigInteger.ONE);
            }
            case -6: 
            case 2: 
            case 5: {
                BigInteger varint = HandleObjects.objectToBITorTINYINTorSMALLINTorNUMERIC(objectClass, object);
                assert (varint != null);
                return JdbcInteger.instance.decompose(varint);
            }
            case 4: {
                Integer value = HandleObjects.objectToINTEGER(objectClass, object);
                assert (value != null);
                return JdbcInt32.instance.decompose(value);
            }
            case -5: {
                Long longvalue = HandleObjects.objectToBIGINT(objectClass, object);
                assert (longvalue != null);
                return JdbcLong.instance.decompose(longvalue);
            }
            case 16: {
                Boolean bool = HandleObjects.objectToBOOLEAN(objectClass, object);
                assert (bool != null);
                return JdbcBoolean.instance.decompose(bool);
            }
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return ByteBufferUtil.bytes((String)((String)object));
            }
            case -4: 
            case -3: 
            case -2: {
                if (objectClass.isAssignableFrom(ByteBuffer.class)) {
                    return (ByteBuffer)object;
                }
                if (objectClass.getSimpleName().equals("byte[]")) {
                    return ByteBuffer.wrap((byte[])object);
                }
                return null;
            }
            case 91: 
            case 92: 
            case 93: {
                Long millis = HandleObjects.objectToDATEorTIMEorTIMESTAMP(objectClass, object);
                assert (millis != null);
                return JdbcLong.instance.decompose(millis);
            }
            case 70: {
                String urlAsString = ((URL)object).toExternalForm();
                return JdbcUTF8.instance.decompose(urlAsString);
            }
            case 2000: {
                return HandleObjects.javaObject(object);
            }
            case -8: {
                byte[] bytes = ((RowId)object).getBytes();
                return ByteBuffer.wrap(bytes);
            }
        }
        LOG.warn("Unhandled JDBC type: " + targetSqlType);
        return null;
    }
}

