/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.sql.RowId;
import org.apache.cassandra.utils.ByteBufferUtil;

class CassandraRowId
implements RowId {
    private final ByteBuffer bytes;

    public CassandraRowId(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte[] getBytes() {
        return ByteBufferUtil.getArray((ByteBuffer)this.bytes);
    }

    @Override
    public String toString() {
        return ByteBufferUtil.bytesToHex((ByteBuffer)this.bytes);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bytes == null ? 0 : this.bytes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraRowId other = (CassandraRowId)obj;
        return !(this.bytes == null ? other.bytes != null : !this.bytes.equals(other.bytes));
    }
}

