/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.carbonado;

import com.amazon.carbonado.Repository;
import griffon.plugins.carbonado.CarbonadoProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCarbonadoProvider
implements CarbonadoProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCarbonadoProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withCarbonado(Closure<R> closure) {
        return this.withCarbonado(DEFAULT, closure);
    }

    @Override
    public <R> R withCarbonado(String repositoryName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)repositoryName)) {
            repositoryName = DEFAULT;
        }
        if (closure != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on repositoryName '" + repositoryName + "'");
            }
            return (R)closure.call(new Object[]{repositoryName, this.getRepository(repositoryName)});
        }
        return null;
    }

    @Override
    public <R> R withCarbonado(CallableWithArgs<R> callable) {
        return this.withCarbonado(DEFAULT, callable);
    }

    @Override
    public <R> R withCarbonado(String repositoryName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)repositoryName)) {
            repositoryName = DEFAULT;
        }
        if (callable != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on repositoryName '" + repositoryName + "'");
            }
            callable.setArgs(new Object[]{repositoryName, this.getRepository(repositoryName)});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract Repository getRepository(String var1);
}

