/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.repo.sleepycat.BDBCursor;
import com.amazon.carbonado.repo.sleepycat.JE_Storage;
import com.amazon.carbonado.repo.sleepycat.JE_Transaction;
import com.amazon.carbonado.txn.TransactionScope;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JE_Cursor<S extends Storable>
extends BDBCursor<JE_Transaction, S> {
    private final Database mDatabase;
    private final LockMode mLockMode;
    private final DatabaseEntry mSearchKey;
    private final DatabaseEntry mData;
    private Cursor mCursor;

    JE_Cursor(TransactionScope<JE_Transaction> scope, byte[] startBound, boolean inclusiveStart, byte[] endBound, boolean inclusiveEnd, int maxPrefix, boolean reverse, JE_Storage<S> storage, Database database) throws DatabaseException, FetchException {
        super(scope, startBound, inclusiveStart, endBound, inclusiveEnd, maxPrefix, reverse, storage);
        this.mDatabase = database;
        this.mLockMode = scope.isForUpdate() ? LockMode.RMW : LockMode.DEFAULT;
        this.mSearchKey = new DatabaseEntry();
        this.mData = new DatabaseEntry();
    }

    protected byte[] searchKey_getData() {
        return JE_Cursor.getData((byte[])this.mSearchKey.getData(), (int)this.mSearchKey.getSize());
    }

    protected byte[] searchKey_getDataCopy() {
        return JE_Cursor.getDataCopy((byte[])this.mSearchKey.getData(), (int)this.mSearchKey.getSize());
    }

    protected void searchKey_setData(byte[] data) {
        this.mSearchKey.setData(data);
    }

    protected void searchKey_setPartial(boolean partial) {
        this.mSearchKey.setPartial(0, 0, partial);
    }

    protected boolean searchKey_getPartial() {
        return this.mSearchKey.getPartial();
    }

    protected byte[] data_getData() {
        return JE_Cursor.getData((byte[])this.mData.getData(), (int)this.mData.getSize());
    }

    protected byte[] data_getDataCopy() {
        return JE_Cursor.getDataCopy((byte[])this.mData.getData(), (int)this.mData.getSize());
    }

    protected void data_setPartial(boolean partial) {
        this.mData.setPartial(0, 0, partial);
    }

    protected boolean data_getPartial() {
        return this.mData.getPartial();
    }

    protected byte[] primaryKey_getData() {
        return JE_Cursor.getData((byte[])this.mSearchKey.getData(), (int)this.mSearchKey.getSize());
    }

    protected void cursor_open(JE_Transaction jetxn, IsolationLevel level) throws Exception {
        CursorConfig config = level == IsolationLevel.READ_COMMITTED ? CursorConfig.READ_COMMITTED : (level == IsolationLevel.READ_UNCOMMITTED ? CursorConfig.READ_UNCOMMITTED : CursorConfig.DEFAULT);
        this.mCursor = this.mDatabase.openCursor(jetxn == null ? null : jetxn.mTxn, config);
    }

    protected void cursor_close() throws Exception {
        Cursor cursor = this.mCursor;
        if (cursor != null) {
            this.mCursor = null;
            cursor.close();
        }
    }

    protected boolean cursor_getCurrent() throws Exception {
        return this.cursor().getCurrent(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getFirst() throws Exception {
        return this.cursor().getFirst(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getLast() throws Exception {
        return this.cursor().getLast(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getSearchKeyRange() throws Exception {
        return this.cursor().getSearchKeyRange(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getNext() throws Exception {
        return this.cursor().getNext(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getNextDup() throws Exception {
        return this.cursor().getNextDup(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getPrev() throws Exception {
        return this.cursor().getPrev(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    protected boolean cursor_getPrevNoDup() throws Exception {
        return this.cursor().getPrevNoDup(this.mSearchKey, this.mData, this.mLockMode) == OperationStatus.SUCCESS;
    }

    private Cursor cursor() throws FetchException {
        Cursor cursor = this.mCursor;
        if (cursor == null) {
            throw new FetchException("Cursor is not open");
        }
        return cursor;
    }
}

