/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import com.amazon.carbonado.util.ConversionComparator;
import com.amazon.carbonado.util.SoftValuedCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Converter {
    private static final SoftValuedCache<Class, Class<? extends Converter>> cCache = SoftValuedCache.newCache(7);

    public static <C extends Converter> C build(Class<C> converterType) {
        try {
            return (C)((Converter)Converter.buildClass(converterType).newInstance());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("TypeConverter must have a public no-arg constructor: " + converterType);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static synchronized <C extends Converter> Class<? extends C> buildClass(Class<C> converterType) {
        Class<Converter> converterClass = cCache.get(converterType);
        if (converterClass == null) {
            converterClass = new Builder<C>(converterType).buildClass();
            cCache.put(converterType, converterClass);
        }
        return converterClass;
    }

    public abstract <T> T convert(Object var1, Class<T> var2);

    public abstract <T> T convert(byte var1, Class<T> var2);

    public abstract <T> T convert(short var1, Class<T> var2);

    public abstract <T> T convert(int var1, Class<T> var2);

    public abstract <T> T convert(long var1, Class<T> var3);

    public abstract <T> T convert(float var1, Class<T> var2);

    public abstract <T> T convert(double var1, Class<T> var3);

    public abstract <T> T convert(boolean var1, Class<T> var2);

    public abstract <T> T convert(char var1, Class<T> var2);

    protected IllegalArgumentException conversionNotSupported(Object fromValue, Class fromType, Class toType) {
        StringBuilder b = new StringBuilder();
        if (fromType == null && fromValue != null) {
            fromType = fromValue.getClass();
        }
        if (fromValue == null) {
            b.append("Actual value null cannot be converted to type ");
        } else {
            b.append("Actual value \"");
            b.append(String.valueOf(fromValue));
            b.append("\", of type \"");
            b.append(TypeDesc.forClass(fromType).getFullName());
            b.append("\", cannot be converted to expected type of ");
        }
        if (toType == null) {
            b.append("null");
        } else {
            b.append('\"');
            b.append(TypeDesc.forClass((Class)toType).getFullName());
            b.append('\"');
        }
        return new IllegalArgumentException(b.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Builder<C extends Converter> {
        private final Class<C> mConverterType;
        private final Map<Class, Map<Class, Method>> mConvertMap;
        private final Class[][] mBoxMatrix = new Class[][]{{Byte.TYPE, Byte.class, Number.class, Object.class}, {Short.TYPE, Short.class, Number.class, Object.class}, {Integer.TYPE, Integer.class, Number.class, Object.class}, {Long.TYPE, Long.class, Number.class, Object.class}, {Float.TYPE, Float.class, Number.class, Object.class}, {Double.TYPE, Double.class, Number.class, Object.class}, {Boolean.TYPE, Boolean.class, Object.class}, {Character.TYPE, Character.class, Object.class}};
        private ClassFile mClassFile;
        private int mInnerConvertCounter;

        Builder(Class<C> converterType) {
            if (!Converter.class.isAssignableFrom(converterType)) {
                throw new IllegalArgumentException("Not a TypeConverter: " + converterType);
            }
            this.mConverterType = converterType;
            this.mConvertMap = new HashMap<Class, Map<Class, Method>>();
            for (Class[] classArray : this.mBoxMatrix) {
                HashMap<Class, Object> to = new HashMap<Class, Object>();
                for (Class toType : classArray) {
                    to.put(toType, null);
                }
                this.mConvertMap.put(classArray[0], to);
                this.mConvertMap.put(classArray[1], to);
            }
            for (Class[] classArray : converterType.getMethods()) {
                Class<?>[] params;
                Class<?> toType;
                if (!classArray.getName().startsWith("convert") || (toType = classArray.getReturnType()) == null || toType == Void.TYPE || (params = classArray.getParameterTypes()) == null || params.length != 1) continue;
                Map<Class, Method> to = this.mConvertMap.get(params[0]);
                if (to == null) {
                    to = new HashMap<Class, Method>();
                    this.mConvertMap.put(params[0], to);
                }
                to.put(toType, (Method)classArray);
            }
            HashMap<Class, Map<Class, Method>> convertMap = new HashMap<Class, Map<Class, Method>>(this.mConvertMap);
            for (Map.Entry entry : convertMap.entrySet()) {
                Class clazz = (Class)entry.getKey();
                HashMap toMap = new HashMap((Map)entry.getValue());
                for (Map.Entry to : toMap.entrySet()) {
                    Class toType = (Class)to.getKey();
                    Method conversionMethod = (Method)to.getValue();
                    this.addAutomaticConversion(clazz, toType, conversionMethod);
                }
            }
        }

        Class<? extends C> buildClass() {
            ClassInjector ci = ClassInjector.create((String)this.mConverterType.getName(), (ClassLoader)this.mConverterType.getClassLoader());
            this.mClassFile = new ClassFile(ci.getClassName(), this.mConverterType);
            this.mClassFile.markSynthetic();
            this.mClassFile.setSourceFile(Converter.class.getName());
            this.mClassFile.setTarget("1.5");
            int ctorCount = 0;
            for (Constructor<?> ctor : this.mConverterType.getDeclaredConstructors()) {
                int modifiers = ctor.getModifiers();
                if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) continue;
                ++ctorCount;
                TypeDesc[] params = new TypeDesc[ctor.getParameterTypes().length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = TypeDesc.forClass(ctor.getParameterTypes()[i]);
                }
                MethodInfo mi = this.mClassFile.addConstructor(Modifiers.PUBLIC, params);
                CodeBuilder b = new CodeBuilder(mi);
                b.loadThis();
                for (int i = 0; i < params.length; ++i) {
                    b.loadLocal(b.getParameter(0));
                }
                b.invokeSuperConstructor(params);
                b.returnVoid();
            }
            if (ctorCount == 0) {
                throw new IllegalArgumentException("TypeConverter has no public or protected constructors: " + this.mConverterType);
            }
            this.addPrimitiveConvertMethod(Byte.TYPE);
            this.addPrimitiveConvertMethod(Short.TYPE);
            this.addPrimitiveConvertMethod(Integer.TYPE);
            this.addPrimitiveConvertMethod(Long.TYPE);
            this.addPrimitiveConvertMethod(Float.TYPE);
            this.addPrimitiveConvertMethod(Double.TYPE);
            this.addPrimitiveConvertMethod(Boolean.TYPE);
            this.addPrimitiveConvertMethod(Character.TYPE);
            Method m = this.getAbstractConvertMethod(Object.class);
            if (m != null) {
                CodeBuilder b = new CodeBuilder(this.mClassFile.addMethod(m));
                b.loadLocal(b.getParameter(0));
                Label notNull = b.createLabel();
                b.ifNullBranch((Location)notNull, false);
                b.loadNull();
                b.returnValue(TypeDesc.OBJECT);
                notNull.setLocation();
                this.addConversionSwitch(b, null);
            }
            return ci.defineClass(this.mClassFile);
        }

        private void addPrimitiveConvertMethod(Class fromType) {
            Method m = this.getAbstractConvertMethod(fromType);
            if (m == null) {
                return;
            }
            CodeBuilder b = new CodeBuilder(this.mClassFile.addMethod(m));
            this.addConversionSwitch(b, fromType);
        }

        private void addConversionSwitch(CodeBuilder b, Class fromType) {
            LocalVariable caseVar;
            Map<Class, Method> caseMap;
            Map<Class, Method> toMap;
            if (fromType == null) {
                HashMap<Class, Map<Class, Method>> convertMap = new HashMap<Class, Map<Class, Method>>(this.mConvertMap);
                Iterator it = convertMap.keySet().iterator();
                while (it.hasNext()) {
                    if (!((Class)it.next()).isPrimitive()) continue;
                    it.remove();
                }
                toMap = null;
                caseMap = convertMap;
            } else {
                caseMap = toMap = this.mConvertMap.get(fromType);
            }
            HashMap<Integer, ArrayList<Class>> caseMatches = new HashMap<Integer, ArrayList<Class>>();
            for (Class to : caseMap.keySet()) {
                int caseValue = to.hashCode();
                ArrayList<Class> matches = (ArrayList<Class>)caseMatches.get(caseValue);
                if (matches == null) {
                    matches = new ArrayList<Class>();
                    caseMatches.put(caseValue, matches);
                }
                matches.add(to);
            }
            int[] cases = new int[caseMatches.size()];
            Label[] switchLabels = new Label[caseMatches.size()];
            Label noMatch = b.createLabel();
            int i = 0;
            for (Integer caseValue : caseMatches.keySet()) {
                cases[i] = caseValue;
                switchLabels[i] = b.createLabel();
                ++i;
            }
            TypeDesc classType = TypeDesc.forClass(Class.class);
            if (toMap == null) {
                b.loadLocal(b.getParameter(0));
                b.invokeVirtual(TypeDesc.OBJECT, "getClass", classType, null);
                caseVar = b.createLocalVariable(null, classType);
                b.storeLocal(caseVar);
            } else {
                caseVar = b.getParameter(1);
            }
            if (caseMap.size() > 1) {
                b.loadLocal(caseVar);
                b.invokeVirtual(Class.class.getName(), "hashCode", TypeDesc.INT, null);
                b.switchBranch(cases, (Location[])switchLabels, (Location)noMatch);
            }
            TypeDesc fromTypeDesc = TypeDesc.forClass((Class)fromType);
            int i2 = 0;
            for (List matches : caseMatches.values()) {
                switchLabels[i2].setLocation();
                int matchCount = matches.size();
                for (int j = 0; j < matchCount; ++j) {
                    Label notEqual;
                    Class toType = (Class)matches.get(j);
                    TypeDesc toTypeDesc = TypeDesc.forClass((Class)toType);
                    b.loadConstant(toTypeDesc);
                    b.loadLocal(caseVar);
                    if (j == matchCount - 1) {
                        notEqual = null;
                        b.ifEqualBranch((Location)noMatch, false);
                    } else {
                        notEqual = b.createLabel();
                        b.ifEqualBranch((Location)notEqual, false);
                    }
                    if (toMap == null) {
                        String name = "convert$" + ++this.mInnerConvertCounter;
                        TypeDesc[] params = new TypeDesc[]{toTypeDesc, classType};
                        MethodInfo mi = this.mClassFile.addMethod(Modifiers.PRIVATE, name, TypeDesc.OBJECT, params);
                        CodeBuilder b2 = new CodeBuilder(mi);
                        this.addConversionSwitch(b2, toType);
                        b.loadThis();
                        b.loadLocal(b.getParameter(0));
                        b.checkCast(toTypeDesc);
                        b.loadLocal(b.getParameter(1));
                        b.invokePrivate(name, TypeDesc.OBJECT, params);
                        b.returnValue(TypeDesc.OBJECT);
                    } else {
                        Method convertMethod = toMap.get(toType);
                        if (convertMethod == null) {
                            b.loadLocal(b.getParameter(0));
                            TypeDesc fromPrimDesc = fromTypeDesc.toPrimitiveType();
                            if (fromPrimDesc != null) {
                                b.convert(fromTypeDesc, fromPrimDesc);
                                b.convert(fromPrimDesc, toTypeDesc.toObjectType());
                            } else {
                                b.convert(fromTypeDesc, toTypeDesc.toObjectType());
                            }
                        } else {
                            b.loadThis();
                            b.loadLocal(b.getParameter(0));
                            Class<?> paramType = convertMethod.getParameterTypes()[0];
                            b.convert(fromTypeDesc, TypeDesc.forClass(paramType));
                            b.invoke(convertMethod);
                            TypeDesc retType = TypeDesc.forClass(convertMethod.getReturnType());
                            b.convert(retType, toTypeDesc.toObjectType());
                        }
                        b.returnValue(TypeDesc.OBJECT);
                    }
                    if (notEqual == null) continue;
                    notEqual.setLocation();
                }
                ++i2;
            }
            noMatch.setLocation();
            TypeDesc valueType = b.getParameter(0).getType();
            if (fromType == null) {
                b.loadLocal(b.getParameter(1));
                b.loadLocal(b.getParameter(0));
                b.invokeVirtual(classType, "isInstance", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.OBJECT});
                Label notSupported = b.createLabel();
                b.ifZeroComparisonBranch((Location)notSupported, "==");
                b.loadLocal(b.getParameter(0));
                b.convert(valueType, valueType.toObjectType());
                b.returnValue(TypeDesc.OBJECT);
                notSupported.setLocation();
            }
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            b.convert(valueType, valueType.toObjectType());
            if (valueType.isPrimitive()) {
                b.loadConstant(valueType);
            } else {
                b.loadNull();
            }
            b.loadLocal(b.getParameter(1));
            b.invokeVirtual("conversionNotSupported", TypeDesc.forClass(IllegalArgumentException.class), new TypeDesc[]{TypeDesc.OBJECT, classType, classType});
            b.throwObject();
        }

        private Method getAbstractConvertMethod(Class fromType) {
            Method m;
            try {
                m = this.mConverterType.getMethod("convert", fromType, Class.class);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            if (!Modifier.isAbstract(m.getModifiers())) {
                return null;
            }
            return m;
        }

        private void addAutomaticConversion(Class fromType, Class toType, Method method) {
            if (method != null) {
                Class<?> returnType;
                Class<?> paramType = method.getParameterTypes()[0];
                if (!paramType.isAssignableFrom(fromType)) {
                    if (!fromType.isPrimitive() && paramType.isPrimitive()) {
                        return;
                    }
                    if (!new ConversionComparator(fromType).isConversionPossible(paramType)) {
                        return;
                    }
                }
                if (!toType.isAssignableFrom(returnType = method.getReturnType())) {
                    if (!returnType.isPrimitive() && toType.isPrimitive()) {
                        return;
                    }
                    if (TypeDesc.forClass(returnType).toObjectType() != TypeDesc.forClass((Class)toType).toObjectType()) {
                        return;
                    }
                }
            }
            this.addConversionIfNotExists(fromType, toType, method);
            this.addConversionIfNotExists(fromType, fromType, null);
            this.addConversionIfNotExists(toType, toType, null);
            for (Class[] pair : this.mBoxMatrix) {
                if (fromType == pair[0]) {
                    this.addConversionIfNotExists(pair[1], toType, method);
                    if (toType == pair[1]) {
                        this.addConversionIfNotExists(pair[1], pair[0], method);
                    }
                } else if (fromType == pair[1]) {
                    this.addConversionIfNotExists(pair[0], toType, method);
                    if (toType == pair[1]) {
                        this.addConversionIfNotExists(pair[0], pair[1], method);
                    }
                }
                if (toType != pair[0]) continue;
                this.addConversionIfNotExists(fromType, pair[1], method);
            }
            if (fromType == Short.TYPE || fromType == Short.class) {
                this.addAutomaticConversion(Byte.TYPE, toType, method);
            } else if (fromType == Integer.TYPE || fromType == Integer.class) {
                this.addAutomaticConversion(Short.TYPE, toType, method);
            } else if (fromType == Long.TYPE || fromType == Long.class) {
                this.addAutomaticConversion(Integer.TYPE, toType, method);
            } else if (fromType == Float.TYPE || fromType == Float.class) {
                this.addAutomaticConversion(Short.TYPE, toType, method);
            } else if (fromType == Double.TYPE || fromType == Double.class) {
                this.addAutomaticConversion(Integer.TYPE, toType, method);
                this.addAutomaticConversion(Float.TYPE, toType, method);
            }
            if (toType == Byte.TYPE || toType == Byte.class) {
                this.addAutomaticConversion(fromType, Short.class, method);
            } else if (toType == Short.TYPE || toType == Short.class) {
                this.addAutomaticConversion(fromType, Integer.class, method);
                this.addAutomaticConversion(fromType, Float.class, method);
            } else if (toType == Integer.TYPE || toType == Integer.class) {
                this.addAutomaticConversion(fromType, Long.class, method);
                this.addAutomaticConversion(fromType, Double.class, method);
            } else if (toType == Float.TYPE || toType == Float.class) {
                this.addAutomaticConversion(fromType, Double.class, method);
            }
        }

        private boolean addConversionIfNotExists(Class fromType, Class toType, Method method) {
            Method existing;
            Map<Class, Method> to = this.mConvertMap.get(fromType);
            if (to == null) {
                to = new HashMap<Class, Method>();
                this.mConvertMap.put(fromType, to);
            }
            if ((existing = to.get(toType)) != null) {
                Class<?> candidateFromType;
                if (method == null) {
                    return false;
                }
                ConversionComparator cc = new ConversionComparator(fromType);
                Class<?> existingFromType = existing.getParameterTypes()[0];
                if (cc.compare(existingFromType, candidateFromType = method.getParameterTypes()[0]) <= 0) {
                    return false;
                }
            }
            to.put(toType, method);
            return true;
        }
    }
}

