/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.TriggerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerManager<S extends Storable>
extends Trigger<S> {
    private static final int FOR_INSERT = 1;
    private static final int FOR_UPDATE = 2;
    private static final int FOR_DELETE = 4;
    private static final int FOR_LOAD = 8;
    private static final Method BEFORE_INSERT_METHOD;
    private static final Method BEFORE_TRY_INSERT_METHOD;
    private static final Method AFTER_INSERT_METHOD;
    private static final Method AFTER_TRY_INSERT_METHOD;
    private static final Method FAILED_INSERT_METHOD;
    private static final Method BEFORE_UPDATE_METHOD;
    private static final Method BEFORE_TRY_UPDATE_METHOD;
    private static final Method AFTER_UPDATE_METHOD;
    private static final Method AFTER_TRY_UPDATE_METHOD;
    private static final Method FAILED_UPDATE_METHOD;
    private static final Method BEFORE_DELETE_METHOD;
    private static final Method BEFORE_TRY_DELETE_METHOD;
    private static final Method AFTER_DELETE_METHOD;
    private static final Method AFTER_TRY_DELETE_METHOD;
    private static final Method FAILED_DELETE_METHOD;
    private static final Method AFTER_LOAD_METHOD;
    private final ForInsert<S> mForInsert = new ForInsert();
    private final ForUpdate<S> mForUpdate = new ForUpdate();
    private final ForDelete<S> mForDelete = new ForDelete();
    private final ForLoad<S> mForLoad = new ForLoad();

    public TriggerManager() {
    }

    public TriggerManager(Class<S> type, Iterable<TriggerFactory> triggerFactories) throws RepositoryException {
        if (triggerFactories != null) {
            this.addTriggers(type, triggerFactories);
        }
    }

    public Trigger<? super S> getInsertTrigger() {
        ForInsert<S> forInsert = this.mForInsert;
        return forInsert.isEmpty() ? null : forInsert;
    }

    public Trigger<? super S> getUpdateTrigger() {
        ForUpdate<S> forUpdate = this.mForUpdate;
        return forUpdate.isEmpty() ? null : forUpdate;
    }

    public Trigger<? super S> getDeleteTrigger() {
        ForDelete<S> forDelete = this.mForDelete;
        return forDelete.isEmpty() ? null : forDelete;
    }

    public Trigger<? super S> getLoadTrigger() {
        ForLoad<S> forLoad = this.mForLoad;
        return forLoad.isEmpty() ? null : forLoad;
    }

    public boolean addTrigger(Trigger<? super S> trigger) {
        if (trigger == null) {
            throw new IllegalArgumentException();
        }
        int types = this.selectTypes(trigger);
        boolean retValue = false;
        if ((types & 1) != 0) {
            retValue |= this.mForInsert.add(trigger);
        }
        if ((types & 2) != 0) {
            retValue |= this.mForUpdate.add(trigger);
        }
        if ((types & 4) != 0) {
            retValue |= this.mForDelete.add(trigger);
        }
        if ((types & 8) != 0) {
            retValue |= this.mForLoad.add(trigger);
        }
        return retValue;
    }

    public boolean removeTrigger(Trigger<? super S> trigger) {
        if (trigger == null) {
            throw new IllegalArgumentException();
        }
        int types = this.selectTypes(trigger);
        boolean retValue = false;
        if ((types & 1) != 0) {
            retValue |= this.mForInsert.remove(trigger);
        }
        if ((types & 2) != 0) {
            retValue |= this.mForUpdate.remove(trigger);
        }
        if ((types & 4) != 0) {
            retValue |= this.mForDelete.remove(trigger);
        }
        if ((types & 8) != 0) {
            retValue |= this.mForLoad.remove(trigger);
        }
        return retValue;
    }

    public void addTriggers(Class<S> type, Iterable<TriggerFactory> triggerFactories) throws RepositoryException {
        for (TriggerFactory factory : triggerFactories) {
            Trigger<S> trigger = factory.triggerFor(type);
            if (trigger == null) continue;
            this.addTrigger(trigger);
        }
    }

    public void locallyDisableInsert() {
        this.mForInsert.locallyDisable();
    }

    public void locallyEnableInsert() {
        this.mForInsert.locallyEnable();
    }

    public void locallyDisableUpdate() {
        this.mForUpdate.locallyDisable();
    }

    public void locallyEnableUpdate() {
        this.mForUpdate.locallyEnable();
    }

    public void locallyDisableDelete() {
        this.mForDelete.locallyDisable();
    }

    public void locallyEnableDelete() {
        this.mForDelete.locallyEnable();
    }

    public void locallyDisableLoad() {
        this.mForLoad.locallyDisable();
    }

    public void locallyEnableLoad() {
        this.mForLoad.locallyEnable();
    }

    @Override
    public Object beforeInsert(S storable) throws PersistException {
        return this.mForInsert.beforeInsert(storable);
    }

    @Override
    public Object beforeTryInsert(S storable) throws PersistException {
        return this.mForInsert.beforeTryInsert(storable);
    }

    @Override
    public void afterInsert(S storable, Object state) throws PersistException {
        this.mForInsert.afterInsert(storable, state);
    }

    @Override
    public void afterTryInsert(S storable, Object state) throws PersistException {
        this.mForInsert.afterTryInsert(storable, state);
    }

    @Override
    public void failedInsert(S storable, Object state) {
        this.mForInsert.failedInsert(storable, state);
    }

    @Override
    public Object beforeUpdate(S storable) throws PersistException {
        return this.mForUpdate.beforeUpdate(storable);
    }

    @Override
    public Object beforeTryUpdate(S storable) throws PersistException {
        return this.mForUpdate.beforeTryUpdate(storable);
    }

    @Override
    public void afterUpdate(S storable, Object state) throws PersistException {
        this.mForUpdate.afterUpdate(storable, state);
    }

    @Override
    public void afterTryUpdate(S storable, Object state) throws PersistException {
        this.mForUpdate.afterTryUpdate(storable, state);
    }

    @Override
    public void failedUpdate(S storable, Object state) {
        this.mForUpdate.failedUpdate(storable, state);
    }

    @Override
    public Object beforeDelete(S storable) throws PersistException {
        return this.mForDelete.beforeDelete(storable);
    }

    @Override
    public Object beforeTryDelete(S storable) throws PersistException {
        return this.mForDelete.beforeTryDelete(storable);
    }

    @Override
    public void afterDelete(S storable, Object state) throws PersistException {
        this.mForDelete.afterDelete(storable, state);
    }

    @Override
    public void afterTryDelete(S storable, Object state) throws PersistException {
        this.mForDelete.afterTryDelete(storable, state);
    }

    @Override
    public void failedDelete(S storable, Object state) {
        this.mForDelete.failedDelete(storable, state);
    }

    @Override
    public void afterLoad(S storable) throws FetchException {
        this.mForLoad.afterLoad(storable);
    }

    private int selectTypes(Trigger<? super S> trigger) {
        Class<?> triggerClass = trigger.getClass();
        int types = 0;
        if (this.overridesMethod(triggerClass, BEFORE_INSERT_METHOD) || this.overridesMethod(triggerClass, BEFORE_TRY_INSERT_METHOD) || this.overridesMethod(triggerClass, AFTER_INSERT_METHOD) || this.overridesMethod(triggerClass, AFTER_TRY_INSERT_METHOD) || this.overridesMethod(triggerClass, FAILED_INSERT_METHOD)) {
            types |= 1;
        }
        if (this.overridesMethod(triggerClass, BEFORE_UPDATE_METHOD) || this.overridesMethod(triggerClass, BEFORE_TRY_UPDATE_METHOD) || this.overridesMethod(triggerClass, AFTER_UPDATE_METHOD) || this.overridesMethod(triggerClass, AFTER_TRY_UPDATE_METHOD) || this.overridesMethod(triggerClass, FAILED_UPDATE_METHOD)) {
            types |= 2;
        }
        if (this.overridesMethod(triggerClass, BEFORE_DELETE_METHOD) || this.overridesMethod(triggerClass, BEFORE_TRY_DELETE_METHOD) || this.overridesMethod(triggerClass, AFTER_DELETE_METHOD) || this.overridesMethod(triggerClass, AFTER_TRY_DELETE_METHOD) || this.overridesMethod(triggerClass, FAILED_DELETE_METHOD)) {
            types |= 4;
        }
        if (this.overridesMethod(triggerClass, AFTER_LOAD_METHOD)) {
            types |= 8;
        }
        return types;
    }

    private boolean overridesMethod(Class<? extends Trigger> triggerClass, Method method) {
        try {
            return !method.equals(triggerClass.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static {
        Class<Trigger> triggerClass = Trigger.class;
        Class[] ONE_PARAM = new Class[]{Object.class};
        Class[] TWO_PARAMS = new Class[]{Object.class, Object.class};
        try {
            BEFORE_INSERT_METHOD = triggerClass.getMethod("beforeInsert", ONE_PARAM);
            BEFORE_TRY_INSERT_METHOD = triggerClass.getMethod("beforeTryInsert", ONE_PARAM);
            AFTER_INSERT_METHOD = triggerClass.getMethod("afterInsert", TWO_PARAMS);
            AFTER_TRY_INSERT_METHOD = triggerClass.getMethod("afterTryInsert", TWO_PARAMS);
            FAILED_INSERT_METHOD = triggerClass.getMethod("failedInsert", TWO_PARAMS);
            BEFORE_UPDATE_METHOD = triggerClass.getMethod("beforeUpdate", ONE_PARAM);
            BEFORE_TRY_UPDATE_METHOD = triggerClass.getMethod("beforeTryUpdate", ONE_PARAM);
            AFTER_UPDATE_METHOD = triggerClass.getMethod("afterUpdate", TWO_PARAMS);
            AFTER_TRY_UPDATE_METHOD = triggerClass.getMethod("afterTryUpdate", TWO_PARAMS);
            FAILED_UPDATE_METHOD = triggerClass.getMethod("failedUpdate", TWO_PARAMS);
            BEFORE_DELETE_METHOD = triggerClass.getMethod("beforeDelete", ONE_PARAM);
            BEFORE_TRY_DELETE_METHOD = triggerClass.getMethod("beforeTryDelete", ONE_PARAM);
            AFTER_DELETE_METHOD = triggerClass.getMethod("afterDelete", TWO_PARAMS);
            AFTER_TRY_DELETE_METHOD = triggerClass.getMethod("afterTryDelete", TWO_PARAMS);
            FAILED_DELETE_METHOD = triggerClass.getMethod("failedDelete", TWO_PARAMS);
            AFTER_LOAD_METHOD = triggerClass.getMethod("afterLoad", ONE_PARAM);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError error = new NoSuchMethodError();
            error.initCause(e);
            throw error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForLoad<S>
    extends ManagedTrigger<S> {
        private ForLoad() {
        }

        @Override
        public void afterLoad(S storable) throws FetchException {
            if (!this.isLocallyDisabled()) {
                Trigger[] triggers = this.mTriggers;
                int i = triggers.length;
                while (--i >= 0) {
                    triggers[i].afterLoad(storable);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDelete<S>
    extends ManagedTrigger<S> {
        private ForDelete() {
        }

        @Override
        public Object beforeDelete(S storable) throws PersistException {
            if (this.isLocallyDisabled()) {
                return null;
            }
            TriggerStates triggerStates = null;
            Trigger[] triggers = this.mTriggers;
            int i = triggers.length;
            while (--i >= 0) {
                Object state = triggers[i].beforeDelete(storable);
                if (state == null) continue;
                if (triggerStates == null) {
                    triggerStates = new TriggerStates(triggers);
                }
                triggerStates.mStates[i] = state;
            }
            return triggerStates == null ? triggers : triggerStates;
        }

        @Override
        public Object beforeTryDelete(S storable) throws PersistException {
            if (this.isLocallyDisabled()) {
                return null;
            }
            TriggerStates triggerStates = null;
            Trigger[] triggers = this.mTriggers;
            int i = triggers.length;
            while (--i >= 0) {
                Object state = triggers[i].beforeTryDelete(storable);
                if (state == null) continue;
                if (triggerStates == null) {
                    triggerStates = new TriggerStates(triggers);
                }
                triggerStates.mStates[i] = state;
            }
            return triggerStates == null ? triggers : triggerStates;
        }

        @Override
        public void afterDelete(S storable, Object state) throws PersistException {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterDelete(storable, null);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterDelete(storable, triggerStates.mStates[i]);
                }
            }
        }

        @Override
        public void afterTryDelete(S storable, Object state) throws PersistException {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterTryDelete(storable, null);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterTryDelete(storable, triggerStates.mStates[i]);
                }
            }
        }

        @Override
        public void failedDelete(S storable, Object state) {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    try {
                        triggers[i].failedDelete(storable, null);
                        continue;
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    try {
                        triggers[i].failedDelete(storable, triggerStates.mStates[i]);
                        continue;
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForUpdate<S>
    extends ManagedTrigger<S> {
        private ForUpdate() {
        }

        @Override
        public Object beforeUpdate(S storable) throws PersistException {
            if (this.isLocallyDisabled()) {
                return null;
            }
            TriggerStates triggerStates = null;
            Trigger[] triggers = this.mTriggers;
            int i = triggers.length;
            while (--i >= 0) {
                Object state = triggers[i].beforeUpdate(storable);
                if (state == null) continue;
                if (triggerStates == null) {
                    triggerStates = new TriggerStates(triggers);
                }
                triggerStates.mStates[i] = state;
            }
            return triggerStates == null ? triggers : triggerStates;
        }

        @Override
        public Object beforeTryUpdate(S storable) throws PersistException {
            if (this.isLocallyDisabled()) {
                return null;
            }
            TriggerStates triggerStates = null;
            Trigger[] triggers = this.mTriggers;
            int i = triggers.length;
            while (--i >= 0) {
                Object state = triggers[i].beforeTryUpdate(storable);
                if (state == null) continue;
                if (triggerStates == null) {
                    triggerStates = new TriggerStates(triggers);
                }
                triggerStates.mStates[i] = state;
            }
            return triggerStates == null ? triggers : triggerStates;
        }

        @Override
        public void afterUpdate(S storable, Object state) throws PersistException {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterUpdate(storable, null);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterUpdate(storable, triggerStates.mStates[i]);
                }
            }
        }

        @Override
        public void afterTryUpdate(S storable, Object state) throws PersistException {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterTryUpdate(storable, null);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterTryUpdate(storable, triggerStates.mStates[i]);
                }
            }
        }

        @Override
        public void failedUpdate(S storable, Object state) {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    try {
                        triggers[i].failedUpdate(storable, null);
                        continue;
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    try {
                        triggers[i].failedUpdate(storable, triggerStates.mStates[i]);
                        continue;
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForInsert<S>
    extends ManagedTrigger<S> {
        private ForInsert() {
        }

        @Override
        public Object beforeInsert(S storable) throws PersistException {
            if (this.isLocallyDisabled()) {
                return null;
            }
            TriggerStates triggerStates = null;
            Trigger[] triggers = this.mTriggers;
            int i = triggers.length;
            while (--i >= 0) {
                Object state = triggers[i].beforeInsert(storable);
                if (state == null) continue;
                if (triggerStates == null) {
                    triggerStates = new TriggerStates(triggers);
                }
                triggerStates.mStates[i] = state;
            }
            return triggerStates == null ? triggers : triggerStates;
        }

        @Override
        public Object beforeTryInsert(S storable) throws PersistException {
            if (this.isLocallyDisabled()) {
                return null;
            }
            TriggerStates triggerStates = null;
            Trigger[] triggers = this.mTriggers;
            int i = triggers.length;
            while (--i >= 0) {
                Object state = triggers[i].beforeTryInsert(storable);
                if (state == null) continue;
                if (triggerStates == null) {
                    triggerStates = new TriggerStates(triggers);
                }
                triggerStates.mStates[i] = state;
            }
            return triggerStates == null ? triggers : triggerStates;
        }

        @Override
        public void afterInsert(S storable, Object state) throws PersistException {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterInsert(storable, null);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterInsert(storable, triggerStates.mStates[i]);
                }
            }
        }

        @Override
        public void afterTryInsert(S storable, Object state) throws PersistException {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterTryInsert(storable, null);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    triggers[i].afterTryInsert(storable, triggerStates.mStates[i]);
                }
            }
        }

        @Override
        public void failedInsert(S storable, Object state) {
            Trigger[] triggers;
            TriggerStates triggerStates;
            if (this.isLocallyDisabled()) {
                return;
            }
            if (state == null) {
                triggerStates = null;
                triggers = this.mTriggers;
            } else if (state instanceof TriggerStates) {
                triggerStates = (TriggerStates)state;
                triggers = triggerStates.mTriggers;
            } else {
                triggerStates = null;
                triggers = (Trigger[])state;
            }
            int length = triggers.length;
            if (triggerStates == null) {
                for (int i = 0; i < length; ++i) {
                    try {
                        triggers[i].failedInsert(storable, null);
                        continue;
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    try {
                        triggers[i].failedInsert(storable, triggerStates.mStates[i]);
                        continue;
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ManagedTrigger<S>
    extends Trigger<S> {
        private static final AtomicReferenceFieldUpdater<ManagedTrigger, ThreadLocal> cDisabledFlagRef = AtomicReferenceFieldUpdater.newUpdater(ManagedTrigger.class, ThreadLocal.class, "mDisabledFlag");
        private static Trigger[] NO_TRIGGERS = new Trigger[0];
        protected volatile Trigger<? super S>[] mTriggers = NO_TRIGGERS;
        private volatile ThreadLocal<AtomicInteger> mDisabledFlag;

        ManagedTrigger() {
        }

        boolean add(Trigger<? super S> trigger) {
            ArrayList<Trigger<S>> list = new ArrayList<Trigger<S>>(Arrays.asList(this.mTriggers));
            if (list.contains(trigger)) {
                return false;
            }
            list.add(trigger);
            this.mTriggers = list.toArray(new Trigger[list.size()]);
            return true;
        }

        boolean remove(Trigger<? super S> trigger) {
            ArrayList<Trigger<S>> list = new ArrayList<Trigger<S>>(Arrays.asList(this.mTriggers));
            if (!list.remove(trigger)) {
                return false;
            }
            this.mTriggers = list.toArray(new Trigger[list.size()]);
            return true;
        }

        boolean isEmpty() {
            return this.mTriggers.length == 0;
        }

        boolean isLocallyDisabled() {
            ThreadLocal<AtomicInteger> disabledFlag = this.mDisabledFlag;
            if (disabledFlag == null) {
                return false;
            }
            AtomicInteger i = disabledFlag.get();
            return i != null && i.get() > 0;
        }

        void locallyDisable() {
            ThreadLocal<AtomicInteger> disabledFlag = this.disabledFlag();
            AtomicInteger i = disabledFlag.get();
            if (i == null) {
                disabledFlag.set(new AtomicInteger(1));
            } else {
                i.incrementAndGet();
            }
        }

        void locallyEnable() {
            AtomicInteger i = this.disabledFlag().get();
            if (i != null) {
                i.decrementAndGet();
            }
        }

        private ThreadLocal<AtomicInteger> disabledFlag() {
            ThreadLocal<AtomicInteger> disabledFlag = this.mDisabledFlag;
            while (disabledFlag == null && !cDisabledFlagRef.compareAndSet(this, null, disabledFlag = new ThreadLocal())) {
                disabledFlag = this.mDisabledFlag;
            }
            return disabledFlag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TriggerStates<S> {
        final Trigger<? super S>[] mTriggers;
        final Object[] mStates;

        TriggerStates(Trigger<? super S>[] triggers) {
            this.mTriggers = triggers;
            this.mStates = new Object[triggers.length];
        }
    }
}

