/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.Alias;
import com.amazon.carbonado.Independent;
import com.amazon.carbonado.PrimaryKey;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Version;
import com.amazon.carbonado.constraint.IntegerConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PrimaryKey(value={"locator"})
@Independent
@Alias(value={"CARBONADO_LOB"})
public abstract class StoredLob
implements Storable<StoredLob> {
    public abstract long getLocator();

    public abstract void setLocator(long var1);

    public abstract int getBlockSize();

    @IntegerConstraint(min=1L)
    public abstract void setBlockSize(int var1);

    public abstract long getLength();

    @IntegerConstraint(min=0L)
    public abstract void setLength(long var1);

    @Version
    public abstract int getVersion();

    public abstract void setVersion(int var1);

    public long getBlockCount() {
        int blockSize = this.getBlockSize();
        return (this.getLength() + (long)(blockSize - 1)) / (long)blockSize;
    }

    public int getLastBlockLength() {
        return (int)(this.getLength() % (long)this.getBlockSize());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PrimaryKey(value={"locator", "+blockNumber"})
    public static abstract class Block
    implements Storable<Block> {
        public abstract long getLocator();

        public abstract void setLocator(long var1);

        public abstract int getBlockNumber();

        public abstract void setBlockNumber(int var1);

        public abstract byte[] getData();

        public abstract void setData(byte[] var1);

        @Version
        public abstract int getVersion();

        public abstract void setVersion(int var1);
    }
}

