/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.replicated;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.lob.AbstractBlob;
import com.amazon.carbonado.lob.Blob;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlobReplicationTrigger<S extends Storable>
extends Trigger<S> {
    private final Storage<S> mMasterStorage;
    private final String[] mBlobNames;

    static <S extends Storable> BlobReplicationTrigger<S> create(Storage<S> masterStorage) {
        Map<String, StorableProperty<S>> properties = StorableIntrospector.examine(masterStorage.getStorableType()).getDataProperties();
        ArrayList<String> blobNames = new ArrayList<String>(2);
        for (StorableProperty<S> property : properties.values()) {
            if (property.getType() != Blob.class) continue;
            blobNames.add(property.getName());
        }
        if (blobNames.size() == 0) {
            return null;
        }
        return new BlobReplicationTrigger<S>(masterStorage, blobNames.toArray(new String[blobNames.size()]));
    }

    private BlobReplicationTrigger(Storage<S> masterStorage, String[] blobNames) {
        this.mMasterStorage = masterStorage;
        this.mBlobNames = blobNames;
    }

    @Override
    public void afterInsert(S replica, Object state) {
        this.afterLoad(replica);
    }

    @Override
    public void afterUpdate(S replica, Object state) {
        this.afterLoad(replica);
    }

    @Override
    public void afterLoad(S replica) {
        for (String name : this.mBlobNames) {
            Blob replicaBlob;
            if (!replica.isPropertySupported(name) || (replicaBlob = (Blob)replica.getPropertyValue(name)) == null || replicaBlob instanceof Replicated && ((Replicated)replicaBlob).parent() == this) continue;
            Replicated blob = new Replicated(this, name, replica, replicaBlob);
            replica.setPropertyValue(name, blob);
        }
        replica.markAllPropertiesClean();
    }

    private static class Copier
    extends OutputStream {
        private final OutputStream mReplicaOut;
        private final OutputStream mMasterOut;

        Copier(OutputStream master, OutputStream replica) {
            this.mMasterOut = master;
            this.mReplicaOut = replica;
        }

        public void write(int b) throws IOException {
            this.mMasterOut.write(b);
            this.mReplicaOut.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.mMasterOut.write(b, off, len);
            this.mReplicaOut.write(b, off, len);
        }

        public void flush() throws IOException {
            this.mMasterOut.flush();
            this.mReplicaOut.flush();
        }

        public void close() throws IOException {
            this.mMasterOut.close();
            this.mReplicaOut.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Replicated
    extends AbstractBlob {
        private static final int DEFAULT_BUFFER_SIZE = 4000;
        private final String mBlobName;
        private final S mReplica;
        private final Blob mReplicaBlob;
        private Blob mMasterBlob;
        private boolean mMasterBlobLoaded;
        final /* synthetic */ BlobReplicationTrigger this$0;

        Replicated(String blobName, S replica, Blob replicaBlob) {
            this.this$0 = var1_1;
            this.mBlobName = blobName;
            this.mReplica = replica;
            this.mReplicaBlob = replicaBlob;
        }

        @Override
        public InputStream openInputStream() throws FetchException {
            return this.mReplicaBlob.openInputStream();
        }

        @Override
        public InputStream openInputStream(long pos) throws FetchException {
            return this.mReplicaBlob.openInputStream(pos);
        }

        @Override
        public InputStream openInputStream(long pos, int bufferSize) throws FetchException {
            return this.mReplicaBlob.openInputStream(pos, bufferSize);
        }

        @Override
        public long getLength() throws FetchException {
            return this.mReplicaBlob.getLength();
        }

        @Override
        public String asString() throws FetchException {
            return this.mReplicaBlob.asString();
        }

        @Override
        public String asString(String charsetName) throws FetchException {
            return this.mReplicaBlob.asString(charsetName);
        }

        @Override
        public String asString(Charset charset) throws FetchException {
            return this.mReplicaBlob.asString(charset);
        }

        @Override
        public OutputStream openOutputStream() throws PersistException {
            Blob masterBlob = this.masterBlob();
            if (masterBlob == null) {
                return this.mReplicaBlob.openOutputStream();
            }
            return this.openOutputStream(masterBlob, 0L, 4000);
        }

        @Override
        public OutputStream openOutputStream(long pos) throws PersistException {
            Blob masterBlob = this.masterBlob();
            if (masterBlob == null) {
                return this.mReplicaBlob.openOutputStream(pos);
            }
            return this.openOutputStream(masterBlob, pos, 4000);
        }

        @Override
        public OutputStream openOutputStream(long pos, int bufferSize) throws PersistException {
            Blob masterBlob = this.masterBlob();
            if (masterBlob == null) {
                return this.mReplicaBlob.openOutputStream(pos, bufferSize);
            }
            return this.openOutputStream(masterBlob, pos, bufferSize);
        }

        private OutputStream openOutputStream(Blob masterBlob, long pos, int bufferSize) throws PersistException {
            if (bufferSize < 4000) {
                bufferSize = 4000;
            }
            OutputStream masterOut = masterBlob.openOutputStream(pos, 0);
            OutputStream replicaOut = this.mReplicaBlob.openOutputStream(pos, 0);
            return new BufferedOutputStream(new Copier(masterOut, replicaOut), bufferSize);
        }

        @Override
        public void setLength(long length) throws PersistException {
            Blob masterBlob = this.masterBlob();
            if (masterBlob != null) {
                masterBlob.setLength(length);
            }
            this.mReplicaBlob.setLength(length);
        }

        @Override
        public Object getLocator() {
            return this.mReplicaBlob.getLocator();
        }

        @Override
        public int hashCode() {
            return this.mReplicaBlob.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Replicated) {
                Replicated other = (Replicated)obj;
                return this.parent() == other.parent() && this.mReplicaBlob.equals(other.mReplicaBlob);
            }
            return false;
        }

        @Override
        public String toString() {
            Object locator = this.getLocator();
            return locator == null ? super.toString() : "ReplicatedBlob@" + locator;
        }

        BlobReplicationTrigger parent() {
            return this.this$0;
        }

        private Blob masterBlob() throws PersistException {
            Blob masterBlob = this.mMasterBlob;
            if (this.mMasterBlobLoaded) {
                return masterBlob;
            }
            Object master = this.this$0.mMasterStorage.prepare();
            this.mReplica.copyPrimaryKeyProperties(master);
            try {
                master.load();
                if (master.isPropertySupported(this.mBlobName) && (masterBlob = (Blob)master.getPropertyValue(this.mBlobName)) == null) {
                    throw new PersistNoneException("Master Blob is null: " + this.mBlobName);
                }
                this.mMasterBlob = masterBlob;
                this.mMasterBlobLoaded = true;
                return masterBlob;
            }
            catch (FetchException e) {
                throw e.toPersistException();
            }
        }
    }
}

