/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.repo.indexed.IndexedRepositoryBuilder;
import com.amazon.carbonado.repo.map.MapRepository;
import com.amazon.carbonado.spi.AbstractRepositoryBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRepositoryBuilder
extends AbstractRepositoryBuilder {
    private String mName = "";
    private boolean mIsMaster = true;
    private boolean mIndexSupport = true;
    private int mLockTimeout;
    private TimeUnit mLockTimeoutUnit;

    public static Repository newRepository() {
        try {
            MapRepositoryBuilder builder = new MapRepositoryBuilder();
            return builder.build();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public MapRepositoryBuilder() {
        this.setLockTimeoutMillis(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository build(AtomicReference<Repository> rootRef) throws RepositoryException {
        if (this.mIndexSupport) {
            this.mIndexSupport = false;
            try {
                IndexedRepositoryBuilder ixBuilder = new IndexedRepositoryBuilder();
                ixBuilder.setWrappedRepository(this);
                ixBuilder.setMaster(this.isMaster());
                ixBuilder.setAllClustered(true);
                Repository repository = ixBuilder.build(rootRef);
                return repository;
            }
            finally {
                this.mIndexSupport = true;
            }
        }
        this.assertReady();
        MapRepository repo = new MapRepository(rootRef, this);
        rootRef.set(repo);
        return repo;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public boolean isMaster() {
        return this.mIsMaster;
    }

    @Override
    public void setMaster(boolean b) {
        this.mIsMaster = b;
    }

    public void setLockTimeoutMillis(int timeout) {
        this.setLockTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public void setLockTimeout(int timeout, TimeUnit unit) {
        if (timeout < 0 || unit == null) {
            throw new IllegalArgumentException();
        }
        this.mLockTimeout = timeout;
        this.mLockTimeoutUnit = unit;
    }

    public int getLockTimeout() {
        return this.mLockTimeout;
    }

    public TimeUnit getLockTimeoutUnit() {
        return this.mLockTimeoutUnit;
    }
}

