/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.logging;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.repo.logging.Log;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoggingTransaction
implements Transaction {
    private static final AtomicLong mNextID = new AtomicLong();
    private final ThreadLocal<LoggingTransaction> mActiveTxn;
    private final LoggingTransaction mParent;
    private final Log mLog;
    private final Transaction mTxn;
    private final long mID;
    private final boolean mTop;

    LoggingTransaction(ThreadLocal<LoggingTransaction> activeTxn, Log log, Transaction txn, boolean top) {
        this.mActiveTxn = activeTxn;
        this.mParent = activeTxn.get();
        this.mLog = log;
        this.mTxn = txn;
        this.mID = mNextID.addAndGet(1L);
        this.mTop = top;
        activeTxn.set(this);
        this.mLog.write("Entered transaction: " + this.idChain());
    }

    @Override
    public void commit() throws PersistException {
        this.mLog.write("Transaction.commit() on " + this.idChain());
        this.mTxn.commit();
    }

    @Override
    public void exit() throws PersistException {
        this.mLog.write("Transaction.exit() on " + this.idChain());
        this.mTxn.exit();
        this.mActiveTxn.set(this.mParent);
    }

    @Override
    public void setForUpdate(boolean forUpdate) {
        if (this.mLog.isEnabled()) {
            this.mLog.write("Transaction.setForUpdate(" + forUpdate + ") on " + this.idChain());
        }
        this.mTxn.setForUpdate(forUpdate);
    }

    @Override
    public boolean isForUpdate() {
        return this.mTxn.isForUpdate();
    }

    @Override
    public void setDesiredLockTimeout(int timeout, TimeUnit unit) {
        this.mTxn.setDesiredLockTimeout(timeout, unit);
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.mTxn.getIsolationLevel();
    }

    @Override
    public void detach() {
        if (this.mLog.isEnabled()) {
            this.mLog.write("Transaction.detach() on " + this.idChain());
        }
        this.mTxn.detach();
    }

    @Override
    public void attach() {
        if (this.mLog.isEnabled()) {
            this.mLog.write("Transaction.attach() on " + this.idChain());
        }
        this.mTxn.attach();
    }

    @Override
    public boolean preCommit() throws PersistException {
        this.mLog.write("Transaction.preCommit() on " + this.idChain());
        return this.mTxn.preCommit();
    }

    private String idChain() {
        if (this.mParent == null) {
            return String.valueOf(this.mID);
        }
        if (this.mTop) {
            return this.mParent.idChain() + " | " + this.mID;
        }
        return this.mParent.idChain() + " > " + this.mID;
    }
}

